package eva.dualwielding.mixin;

import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.BlockAccess;
import eva.dualwielding.access.PlayerAccess;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import static eva.dualwielding.util.CollectiveImpl.slowVein;

@Mixin(class_4970.class)
public abstract class BlockBehaviourMixin implements BlockAccess {

    @Unique
    public float dualWielding$getDestroyProgress(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float f = state.method_26214(world, pos);
        if (f == -1.0F) {
            return 0.0F;
        } else {
            int i = ((PlayerAccess) player).dualWielding$hasCorrectToolForDrops(state) ? 30 : 100;
            return ((PlayerAccess) player).dualWielding$getDestroySpeed(state) / f / i;
        }
    }

    @Mixin(class_4970.class_4971.class)
    public abstract static class BlockStateBaseMixin implements BlockAccess {

        @Unique private final class_4970.class_4971 abs = (class_4970.class_4971) (Object) this;

        @Unique
        public float dualWielding$getDestroyProgress(class_1657 player, class_1922 world, class_2338 pos) {
            float f = ((BlockAccess)abs.method_26204()).dualWielding$getDestroyProgress(this.shadow$asState(), player, world, pos);
            if (DualWieldingMain.collectiveLoaded()) {
                return Math.max(f, slowVein((class_1937) world, player, f, this.shadow$asState()));
            }
            return f;
        }

        @Shadow
        protected abstract class_2680 shadow$asState();
    }

}
