package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.MultiPlayerGameModeAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.util.IsMining;
import eva.dualwielding.util.LastAct;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

import static eva.dualwielding.config.ConfigInterpreter.*;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public class MinecraftMixin {

    @Shadow @Nullable public class_746 player;
    @Shadow @Nullable public class_636 gameMode;
    @Shadow @Nullable public class_239 hitResult;
    @Shadow @Nullable public class_638 level;
    @Shadow public int missTime;

    @Unique private int secondAttackCooldown;
    @Unique private boolean held = false;
    @Unique private LastAct noSwap = LastAct.NULL;
    @Unique private IsMining isMining = IsMining.NULL;
    @Unique private final class_310 tMc = (class_310) (Object) this;

    @Unique private boolean isOffhand = false;

    @Unique private boolean breaki = false;

    @Inject(method = "startUseItem", at = @At("RETURN"))
    private void spamFixer(CallbackInfo ci) {held = false;}

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;handleKeybinds()V"))
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/InteractionResult$Success;swingSource()Lnet/minecraft/world/InteractionResult$SwingSource;"
            )
    )
    private void set(CallbackInfo ci) {
        noSwap = LastAct.USE;
    }

    @Inject(method = "startUseItem", at = @At("HEAD"), cancellable = true)
    private void keepMining(CallbackInfo ci) {
        if (noSwap == LastAct.ATTACK && held)
            this.doUseHit(ci, class_1268.field_5810, new class_1269.class_9859(), true);
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"),
            cancellable = true)
    private void blockItemUseAction(CallbackInfo ci, @Local class_1268 hand) {
        assert player != null;
        if (hand == class_1268.field_5810 && checkUseRestricted(player.method_6079(), player.method_18276())) {
            this.doUseHit(ci, class_1268.field_5810, new class_1269.class_9859(), true);
            ci.cancel();
        }
    }

    @Inject(
            method = "startUseItem",
            at = @At(
                    value = "RETURN",
                    shift = At.Shift.BY,
                    by = 2
            ),
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z",
                            ordinal = 1
                    )
            ),
            cancellable = true
    )
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        assert this.gameMode != null;
        assert player != null;
        if (hand == class_1268.field_5810)
            this.doUseHit(ci, hand, new class_1269.class_9859(), false);
        else
            noSwap = LastAct.NULL;
    }

    @Unique
    private void doUseHit(CallbackInfo ci, class_1268 hand, class_1269 actRes, boolean skippedTo) {
        assert player != null;
        breaki = false;
        class_1799 stack = player.method_6079();
        boolean[] bl = {checkEmpty(stack), checkMiner(stack), checkAttacker(stack)};
        if (bl[0] || !(!bl[1] && !bl[2]))
            if (!(!skippedTo && (hand != class_1268.field_5810 || (noSwap == LastAct.USE && !held))))
                if (actRes instanceof class_1269.class_9857 || actRes instanceof class_1269.class_9859) {
                    if (!player.method_7325())
                        if (this.secondAttackCooldown <= 0)
                            if (this.hitResult != null && !player.method_3144()) {
                                noSwap = LastAct.ATTACK;
                                switch (Objects.requireNonNull(this.hitResult).method_17783()) {
                                    case field_1331:
                                        if (!held && (bl[0] || bl[2])) {
                                            // Client
                                            ((PlayerAccess) this.player).dualWielding$attackOffhand(((class_3966)hitResult).method_17782());
                                            // Server
                                            ClientPlayNetworking.send(new AttackPayload(((class_3966) this.hitResult).method_17782().method_5628()));
                                            assert this.gameMode != null;
                                            if (this.gameMode.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                        } else return;
                                        break;
                                    case field_1332:
                                        if (!Objects.requireNonNull(player.method_68876()).method_8386() && (bl[0] || bl[1])) {
                                            class_3965 blockHitResult = (class_3965) this.hitResult;
                                            class_2338 blockPos = blockHitResult.method_17777();
                                            assert level != null;
                                            if (!level.method_8320(blockPos).method_26215()) {
                                                assert this.gameMode != null;
                                                if (!held)
                                                    ((MultiPlayerGameModeAccess) this.gameMode).dualWielding$attackBlock(blockPos, blockHitResult.method_17780());
                                                else if (level.method_8320(blockPos).method_26215())
                                                    breaki = true;
                                            }
                                        } else return;
                                        break;
                                    case field_1333:
                                        if (!held && (checkEmpty(stack) || checkAttacker(player.method_6079()))) {
                                            assert this.gameMode != null;
                                            if (this.gameMode.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                            ((PlayerAccess) player).dualWielding$resetAttackStrengthTicker();
                                        } else return;
                                }

                                this.player.method_6104(hand);
                                held = false;
                                ci.cancel();
                            }
                }
    }

    @Inject(method = "handleKeybinds",
            at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/Minecraft;startUseItem()V",
            ordinal = 1))
    private void noHolding(CallbackInfo ci){
        held = true;
    }

    @Inject(method = "continueAttack", at = @At(value = "HEAD"), cancellable = true)
    private void stopSimulMine(CallbackInfo ci) {
        if (isMining == IsMining.OFF) {
            isMining = IsMining.NULL;
            ci.cancel();
        }
    }

    @Inject(method = "continueAttack",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;"))
    private void setMiningMain(CallbackInfo ci) {
        isMining = IsMining.MAIN;
    }

    @Inject(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"
            )
    )
    private void handleBlockBreaking(CallbackInfo ci) {
        if (isMining == IsMining.MAIN)
            isMining = IsMining.NULL;
        else if (noSwap != LastAct.USE)
            offHandMine(tMc.field_1755 == null && !breaki && tMc.field_1690.field_1904.method_1434() && tMc.field_1729.method_1613());
    }

    @Unique
    private void offHandMine(boolean breaking) {
        assert player != null;
        if (checkEmpty(player.method_6079()) || checkMiner(player.method_6079())) {
            if (!Objects.requireNonNull(player.method_68876()).method_8386()) {
                isOffhand = true;
                tMc.method_1590(breaking);
                isOffhand = false;

//                if (!breaking) {
//                    secondAttackCooldown = 0;
//                }
//                if (secondAttackCooldown <= 0) {
//                    if (!this.player.isUsingItem()) {
//                        assert this.gameMode != null;
//                        if (breaking && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK) {
//                            isMining = IsMining.OFF;
//                            BlockHitResult blockHitResult = (BlockHitResult) this.hitResult;
//                            BlockPos blockPos = blockHitResult.getBlockPos();
//                            assert level != null;
//                            if (!level.getBlockState(blockPos).isAir()) {
//                                Direction direction = blockHitResult.getDirection();
//                                if (((MultiPlayerGameModeAccess) this.gameMode).dualWielding$updateBlockBreakingProgress(blockPos, direction)) {
//                                    assert tMc.level != null;
//                                    tMc.level.addBreakingBlockEffect(blockPos, direction);
//                                    this.player.swing(InteractionHand.OFF_HAND);
//                                }
//                            }
//                        } else {
//                            ((MultiPlayerGameModeAccess) this.gameMode).dualWielding$cancelBlockBreaking(isMining);
//                        }
//                    }
//                }
            }
        }
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 0
            )
    )
    private void missTimeSET(class_310 instance, int value) {
        if (isOffhand) secondAttackCooldown = value;
        else missTime = value;
    }

    @ModifyExpressionValue(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 1
            )
    )
    private int missTimeGET(int original) {
        if (isOffhand) return secondAttackCooldown;
        return original;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean executeContinueDestroyBlock(class_636 instance, class_2338 posBlock, class_2350 directionFacing) {
        if (isOffhand) return ((MultiPlayerGameModeAccess) instance).dualWielding$updateBlockBreakingProgress(posBlock, directionFacing);
        return instance.method_2902(posBlock, directionFacing);
    }

    @ModifyArg(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private class_1268 replaceMainHandArg(class_1268 hand) {
        if (isOffhand) return class_1268.field_5810;
        return hand;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;stopDestroyBlock()V"
            )
    )
    private void stopDestroyBlock(class_636 instance) {
        if (isOffhand) ((MultiPlayerGameModeAccess) instance).dualWielding$cancelBlockBreaking(isMining);
        else instance.method_2925();
    }

}