package eva.dualwielding.config;

import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.config.enums.Handy;
import eva.dualwielding.config.enums.ItemCat;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

import static eva.dualwielding.config.SimplyDualWieldingConfig.*;

public class ConfigInterpreter {

    private static final SimplyDualWieldingConfig[] INSTANCE = {getServerInstance(), getInstance()};
    private static Boolean server;
    private static final boolean[] allowWeak = getServerInstance() != null ? getServerInstance().getAllowWeakConfig() : new boolean[]{true, true, true, true};
    private static boolean[] handy = {false, false};

    public static boolean checkEmpty(class_1799 stack) {
        if (stack.method_7960()) {
            if (!checkServer() || INSTANCE[0].getEmpty() && allowWeak[0])
                return INSTANCE[1].getEmpty();
            return INSTANCE[0].getEmpty();
        }
        return false;
    }

    public static boolean checkAttacker(class_1799 stack) {
        return checker(stack, 0);
    }

    public static boolean checkMiner(class_1799 stack) {
        return checker(stack, 1);
    }

    private static boolean checker(class_1799 stack, int ind) {
        if (stack.method_7960()) return false;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        for (int lim = (checkServer() && !allowWeak[ind]) ? 1 : 2; i < lim; i++) {
            ItemCat[] cat = {INSTANCE[i].getAttacks(), INSTANCE[i].getMines()};
            comp[i] = switch (cat[ind]) {
                case ALL -> true;
                case TOOLS -> stack.method_31573(class_3489.field_42616) && !stack.method_31573(class_3489.field_42611) && !stack.method_31574(class_1802.field_8547);
                case WEAPONS -> stack.method_31573(class_3489.field_42611) || stack.method_31573(class_3489.field_42612) || stack.method_31574(class_1802.field_8547);
                case TOOLS_AND_WEAPONS -> stack.method_31573(class_3489.field_42616);
                case NONE -> false;
                case BLACKLIST -> !checkList(ind, i, stack.method_7909());
                case WHITELIST -> checkList(ind, i, stack.method_7909());
                case null -> false;
            };
        }
        if (!checkServer() || comp[0] && allowWeak[ind])
            return comp[1];
        return comp[0];
    }

    public static boolean checkUseRestricted(class_1799 stack, boolean sneaking) {
        if (stack.method_7960()) return false;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        for (int lim = (checkServer() && INSTANCE[0].getAllowWeakConfig(3)) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (INSTANCE[i].getRestrictUse()) {
                case ALWAYS -> checkList(2, i, stack.method_7909());
                case SNEAKING_ONLY -> sneaking && checkList(2, i, stack.method_7909());
                case NOT_SNEAKING -> !sneaking && checkList(2, i, stack.method_7909());
                case NEVER -> false;
            };
        }
        if (!checkServer() || !comp[0] && INSTANCE[0].getAllowWeakConfig(3))
            return comp[1];
        return comp[0];
    }

    private static boolean checkList(int w, int i, class_1792 item) {
        Set<class_2960> set = switch (w) {
            case 0 -> getSetFromList(INSTANCE[i].getAttackItems());
            case 1 -> getSetFromList(INSTANCE[i].getMineItems());
            case 2 -> getSetFromList(INSTANCE[i].getDisableUseItems());
            default -> ConcurrentHashMap.newKeySet();
        };
        return set.contains(class_7923.field_41178.method_10221(item));
    }

    private static boolean checkServer() {
        if (server == null) {
            server = INSTANCE[0] != null;
        }
        return server;
    }

    public static float modifyDamage(float damage, class_1657 player) {
        boolean bl = ((LivingEntityAccess) player).offhand(false);
        class_1268 hand = bl ? class_1268.field_5810 : class_1268.field_5808;
        if (player.method_5998(hand).method_7960()) {
            ((LivingEntityAccess) player).offhand(bl);
            return damage;
        }
        int i = 1;
        if (checkServer()) i = 0;
        Handy handed;
        boolean[] handy = new boolean[]{player.method_6047().method_7926(class_1304.field_6173).containsKey(class_5134.field_23721), player.method_6079().method_7926(class_1304.field_6173).containsKey(class_5134.field_23721)};
        if (handy[0] || handy[1]) {
            if (handy[0] && handy[1]) handed = Handy.DUAL;
            else if (player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_7960())
                handed = Handy.TWO_HAND;
            else handed = Handy.ONE_HAND;
        }
        else {
            ((LivingEntityAccess) player).offhand(bl);
            return damage;
        }
        double[] vals = switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED -> new double[]{.8, 1, 1.2};
            case CUSTOM_BALANCE -> INSTANCE[i].getValues();
            default -> new double[]{1, 1, 1};
        };
        damage *= (float) vals[handed.ordinal()];
        ((LivingEntityAccess) player).offhand(bl);
        return damage;
    }

    public static float modifyASpd(float refreshRate, class_1657 player, class_1268 hand) {
        if (player.method_5998(hand).method_7960()) return refreshRate;
        int i = 1;
        if (checkServer()) i = 0;
        Handy handed;
        boolean[] handy = new boolean[]{player.method_6047().method_7926(class_1304.field_6173).containsKey(class_5134.field_23721), player.method_6079().method_7926(class_1304.field_6173).containsKey(class_5134.field_23721)};
        if (handy[0] || handy[1]) {
            if (handy[0] && handy[1]) handed = Handy.DUAL;
            else if (player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_7960())
                handed = Handy.TWO_HAND;
            else handed = Handy.ONE_HAND;
        }
        else return refreshRate;
        double[] vals = switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED -> new double[]{.8, 1, 1.2};
            case CUSTOM_BALANCE -> INSTANCE[i].getValues();
            default -> new double[]{1, 1, 1};
        };
        refreshRate /= (float) vals[(handed.ordinal() + 3) % vals.length];
        return refreshRate;
    }
}


