package eva.dualwielding.network;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.config.enums.BalanceMode;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.ItemCat;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.function.Function;

public record ConfigPacket(SimplyDualWieldingConfig heldInstance) implements FabricPacket {

    public static final class_2960 CONFIG_PACKET_ID = class_2960.method_43902("eva", "config");
    public static final PacketType<ConfigPacket> TYPE = PacketType.create(CONFIG_PACKET_ID, new Function<class_2540, ConfigPacket>() {
        @Override
        public ConfigPacket apply(class_2540 buf) {
            return new ConfigPacket(buildFromBuf(buf));
        }
    });

    private static SimplyDualWieldingConfig buildFromBuf(class_2540 buf) {
        boolean empty = buf.readBoolean();
        int p = buf.readByte();
        boolean[] allowWeak = {false, false, false, false};
        for (int i = 3; i >= 0; i--) {
            if (p >= (int) Math.pow(2, i)) {
                allowWeak[i] = true;
                p -= (int) Math.pow(2, i);
            }
        }
        return new SimplyDualWieldingConfig(
                empty,
                buf.method_10818(ItemCat.class),
                buf.method_10818(ItemCat.class),
                buf.method_10818(ConditionalBehavior.class),
                allowWeak,
                buf.method_10818(BalanceMode.class)
        );
    }

    public void write(class_2540 buf) {
        buf.writeBoolean(heldInstance.getEmpty());
        boolean[] allowWeak = heldInstance.getAllowWeakConfig();
        int p = 0;
        for (int i = 0; i < 4; i++)
            if (allowWeak[i])
                p += (int) Math.pow(2, i);
        buf.writeByte(p);
        buf.method_10817(heldInstance.getAttacks());
        buf.method_10817(heldInstance.getMines());
        buf.method_10817(heldInstance.getRestrictUse());
        buf.method_10817(heldInstance.getMode());
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public SimplyDualWieldingConfig getHeldInstance() {
        return heldInstance;
    }

}