package eva.dualwielding.network;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;


public record ListPacket(int[] rawIds) implements FabricPacket {

    public static final class_2960 LIST_PACKET_ID = class_2960.method_43902("eva", "list");

    public static PacketType<ListPacket> TYPE = PacketType.create(LIST_PACKET_ID, new Function<class_2540, ListPacket>() {
        @Override
        public ListPacket apply(class_2540 buf) {
            return new ListPacket(read(buf));
        }
    });

    public ListPacket(List<String> ids) {
        this(asIntArray(ids));
    }

    private static int[] read(class_2540 buf) {
        return buf.method_10787();
    }

    public void write(class_2540 buf) {
        buf.method_10806(rawIds);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    private static int[] asIntArray(List<String> ids) {
        int[] rawIds = new int[ids.size()];
        for (int i = 0; i < ids.size(); i++) {
            if (Objects.equals(ids.get(i), ""))
                rawIds[i] = 0;
            else
                rawIds[i] = class_7923.field_41178.method_10206(class_7923.field_41178.method_10223(class_2960.method_12829(ids.get(i))));
        }
        return rawIds;
    }

    private static List<String> asStringList(int[] rawIds) {
        List<String> ids = new ArrayList<>();
        for (int rawId : rawIds) {
            if (rawId == 0)
                ids.add("");
            else
                ids.add(class_7923.field_41178.method_10221(class_7923.field_41178.method_10200(rawId)).toString());
        }
        return ids;
    }

    public List<String> getList() {
        return asStringList(rawIds);
    }

}