package eva.dualwielding.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.LivingEntityAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5131;
import net.minecraft.class_5135;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityAccess {

    @Final @Shadow private class_5131 attributes;

    @Unique private boolean isOffHand = false;
    @Unique private class_5131 offhandAttributes;

    @Unique
    public boolean isOffhand() {return isOffHand;}

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void init(class_1299<? extends class_1309> entityType, class_1937 level, CallbackInfo ci) {
        this.offhandAttributes = new class_5131(class_5135.method_26873(entityType));
        if ((class_1309) (Object) this instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Inject(
            method = "getItemBySlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void mainHandStackChanger(CallbackInfoReturnable<class_1799> cir, @Local(argsOnly = true) class_1304 slot) {
        if (slot.equals(class_1304.field_6173) && isOffHand) {
            cir.setReturnValue(((class_1309) (Object) this).method_6079());
            cir.cancel();
        }
    }

    @Inject(
            method = "collectEquipmentChanges",
            at = @At("TAIL")
    )
    private void offhandItemChangedSomehowIdkHow(
            CallbackInfoReturnable<Map<class_1304, class_1799>> cir
    ) {
        if (((class_1309) (Object) this) instanceof class_1657)
            offhandAttributeSetter((class_1657) (Object) this);
    }

    @Unique
    private void offhandAttributeSetter(class_1657 player) {
        class_1799 main;
        class_1799 off;
        try {
            main = player.method_6047();
        }
        catch (NullPointerException exception) {
            main = class_1799.field_8037;
        }
        try {
            off = player.method_6079();
        }
        catch (NullPointerException exception) {
            off = class_1799.field_8037;
        }
        offhandAttributes = attributes;
        if (main != class_1799.field_8037 && main.method_57826(class_9334.field_49636)) {
            List<class_9285.class_9287> components = Objects.requireNonNull(main.method_57353().method_58694(class_9334.field_49636)).comp_2393();
            components.forEach(mod -> {
                if (mod.comp_2397() == class_9274.field_49217) {
                    Objects.requireNonNull(offhandAttributes.method_45329(mod.comp_2395())).method_6202(mod.comp_2396());
                }
            });
        }
        if (off != class_1799.field_8037 && off.method_57826(class_9334.field_49636)) {
            List<class_9285.class_9287> components = Objects.requireNonNull(off.method_57353().method_58694(class_9334.field_49636)).comp_2393();
            components.forEach(mod -> {
                if (mod.comp_2397() == class_9274.field_49217) {
                    Objects.requireNonNull(offhandAttributes.method_45329(mod.comp_2395())).method_55696(mod.comp_2396());
                }
            });
        }
    }

    @Override
    public void dualWielding$setMainHandStack(boolean isOffHand) {
        this.isOffHand = isOffHand;
    }

    @Override
    public net.minecraft.class_5131 offhandAttributes() {
        return offhandAttributes;
    }
}