package eva.dualwielding.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.init.ParticleInit;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static eva.dualwielding.config.ConfigInterpreter.checkRA;

@Mixin(value = class_1657.class, priority = 1001)
public abstract class PlayerMixin implements PlayerAccess {

    @Unique
    private int lastAttackedOffhandTicks;
    @Unique
    private final class_1657 pe = (class_1657) (Object) this;

    @Inject(method = "tick()V", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I", ordinal = 0))
    private void tickMixin(CallbackInfo info) {
        lastAttackedOffhandTicks++;
    }

    @Unique
    public float dualWielding$getOffhandItemAttackStrengthDelay() {
        return (float) ((double) 1.0F / ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23723) * (double) 20.0F);
    }

    @Unique
    public void dualWielding$resetLastAttackTicks() {
        this.lastAttackedOffhandTicks = 0;
    }

    @Unique
    public float dualWielding$getAttackStrengthScale(float baseTime) {
        return class_3532.method_15363(((float) this.lastAttackedOffhandTicks + baseTime) / this.dualWielding$getOffhandItemAttackStrengthDelay(), 0.0F, 1.0F);
    }

    @Unique
    public boolean dualWielding$blockActionRestricted(class_1937 level, class_2338 pos, class_1934 gameMode) {
        return pe.method_68878() || pe.method_21701(level, pos, gameMode);
    }

    @Unique
    public boolean dualWielding$canHarvest(class_2680 state) {
        return !state.method_29291() || pe.method_6079().method_7951(state);
    }

    @Unique
    public void dualWielding$attackOffhand(class_1297 target) {
        if (checkRA(pe, target)) return;
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(true);
        pe.method_7324(target);
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(false);
    }

    @Inject(
            method = "attack",
            at = @At("HEAD")
    )
    private void noInvulnerabilityForYou(class_1297 target, CallbackInfo ci) {
        target.field_6008 = 0;
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 0
            )
    )
    private double attackAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23721);
        return original;
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F"
            )
    )
    private float strengthScaleGET(float original) {
        if (((LivingEntityAccess) pe).isOffhand()) return dualWielding$getAttackStrengthScale(0.5F);
        return original;
    }

    @Redirect(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V"
            )
    )
    private void attackStrengthResetter(class_1657 pe) {
        if (((LivingEntityAccess) pe).isOffhand()) ((PlayerAccess) pe).dualWielding$resetLastAttackTicks();
        else pe.method_7350();
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 mainHandChanger(class_1799 original) {
        return pe.method_59958();
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 1
            )
    )
    private double attackSpeedAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23723);
        return original;
    }

    @Redirect(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;sweepAttack()V"
            )
    )
    private void sweepAttack(class_1657 pe) {
        if (((LivingEntityAccess) pe).isOffhand()) {
            double posOne = -class_3532.method_15374(pe.method_36454() * ((float) Math.PI / 180));
            double posTwo = class_3532.method_15362(pe.method_36454() * ((float) Math.PI / 180));
            if (pe.method_37908() instanceof class_3218)
                ((class_3218) pe.method_37908()).method_65096(ParticleInit.OFFHAND_SWEEPING, pe.method_23317() + posOne, pe.method_23323(0.5D), pe.method_23321() + posTwo, 0,
                        posOne, 0.0D, posTwo, 0.0D);
        } else pe.method_7263();
    }

    @ModifyArg(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;setItemInHand(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"
            )
    )
    private class_1268 handArgSwap(class_1268 hand) {
        return switch (hand) {
            case field_5808 -> class_1268.field_5810;
            case field_5810 -> class_1268.field_5808;
        };
    }

    @Unique
    public float dualWielding$getDestroySpeed(class_2680 block) {
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(true);
        float returnal = pe.method_7351(block);
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(false);
        return returnal;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 0
            )
    )
    private double efficiencyAttributeValue(double original) {
        if (((LivingEntityAccess) pe).isOffhand()) {
            float f = (float) original;
            f += (float) ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51581);
            int p = class_1890.method_8225(pe.method_56673().method_30530(class_7924.field_41265).method_46747(class_1893.field_9131), pe.method_6079());
            if (p > 0) f += p * p + 1;
            return f;
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 1
            )
    )
    private double blockBreakSpeedAttributeValue(double original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51581);
        return original;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttribute(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;"
            )
    )
    private class_1324 subSpeedAttributeValue(class_1324 original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ((LivingEntityAccess) pe).offhandAttributes().method_45329(class_5134.field_51576);
        return original;
    }


}
