/*
 * Decompiled with CFR 0.152.
 */
package net.nullcoil.soulscorch.entity.custom;

import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_5137;
import net.minecraft.class_5425;
import net.nullcoil.soulscorch.effect.ModEffects;
import net.nullcoil.soulscorch.sound.ModSounds;
import net.nullcoil.soulscorch.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class RestlessEntity
extends class_1588
implements class_1569,
class_5137 {
    private static final class_2940<Boolean> AWAKENED;
    private static Boolean aiming;
    private class_243 chargeDirection;

    public RestlessEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        float yaw = this.field_5974.method_43057() * 360.0f - 180.0f;
        this.method_36456(yaw);
        this.method_5847(yaw);
        this.method_5636(yaw);
        this.method_7217(false);
        return data;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(AWAKENED, (Object)false);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_5136.method_26937().method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23719, 0.6);
    }

    protected void method_5959() {
        this.field_6201.method_6277(7, (class_1352)new LookAtTargetGoal(this));
        this.field_6201.method_6277(0, (class_1352)new BullrushGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public boolean getAwakened() {
        return (Boolean)this.field_6011.method_12789(AWAKENED);
    }

    public void setAwakened(Boolean awakened) {
        this.field_6011.method_12778(AWAKENED, (Object)awakened);
        if (awakened.booleanValue()) {
            this.method_56078(ModSounds.RESTLESS_ANGER);
        }
    }

    public boolean method_5753() {
        return true;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected class_3414 method_5994() {
        if (!this.getAwakened()) {
            return (class_3414)class_3417.field_23060.comp_349();
        }
        return class_3417.field_14993;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.SOULLESS_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.RESTLESS_DEATH;
    }

    public int method_24657() {
        return 0;
    }

    static {
        aiming = false;
        AWAKENED = class_2945.method_12791(RestlessEntity.class, (class_2941)class_2943.field_13323);
    }

    static class LookAtTargetGoal
    extends class_1352 {
        private final RestlessEntity restless;

        public LookAtTargetGoal(RestlessEntity restless) {
            this.restless = restless;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.restless.getAwakened() && aiming != false;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.restless.method_5968() == null) {
                class_243 vec3d = this.restless.method_18798();
                this.restless.method_36456(-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f);
                this.restless.field_6283 = this.restless.method_36454();
            } else {
                class_1309 livingEntity = this.restless.method_5968();
                if (livingEntity.method_5858((class_1297)this.restless) < 4096.0) {
                    double e = livingEntity.method_23317() - this.restless.method_23317();
                    double f = livingEntity.method_23321() - this.restless.method_23321();
                    this.restless.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                    this.restless.field_6283 = this.restless.method_36454();
                }
            }
        }
    }

    public class BullrushGoal
    extends class_1352 {
        private final RestlessEntity mob;
        private class_1309 target;
        private class_243 interceptPoint;
        private int timer;
        private State state = State.DONE;

        public BullrushGoal(RestlessEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.getAwakened() && this.mob.method_5968() != null;
        }

        public void method_6269() {
            this.target = this.mob.method_5968();
            this.timer = 60;
            this.state = State.WAITING;
            this.interceptPoint = null;
        }

        public void method_6268() {
            switch (this.state.ordinal()) {
                case 0: {
                    class_243 chargeDir;
                    aiming = true;
                    this.mob.method_5942().method_6340();
                    if (this.target != null && !this.target.method_31481()) {
                        double dx = this.target.method_23317() - this.mob.method_23317();
                        double dz = this.target.method_23321() - this.mob.method_23321();
                        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                        this.mob.method_36456(yaw);
                        this.mob.method_5636(yaw);
                        this.mob.method_5847(yaw);
                    }
                    --this.timer;
                    if (this.timer > 0) break;
                    class_243 playerVel = this.target.method_18798();
                    this.interceptPoint = InterceptHelper.computeIntercept(this.mob.method_19538(), this.target.method_19538(), playerVel, 0.35);
                    RestlessEntity.this.chargeDirection = chargeDir = this.interceptPoint.method_1020(this.mob.method_19538()).method_1029();
                    this.timer = 60;
                    this.state = State.CHARGING;
                    break;
                }
                case 1: {
                    aiming = false;
                    this.mob.method_5784(class_1313.field_6308, RestlessEntity.this.chargeDirection.method_1021(this.mob.method_45325(class_5134.field_23719)));
                    this.mob.field_6037 = true;
                    this.mob.method_36456((float)Math.toDegrees(Math.atan2(-RestlessEntity.this.chargeDirection.field_1352, RestlessEntity.this.chargeDirection.field_1350)));
                    this.mob.method_5636(this.mob.method_36454());
                    this.mob.method_5847(this.mob.method_36454());
                    this.mob.method_5942().method_6340();
                    this.mob.method_5980(null);
                    this.mob.method_37908().method_8333((class_1297)this.mob, this.mob.method_5829().method_1014(0.5), e -> e instanceof class_1309 && e != this.mob).forEach(e -> {
                        double dz;
                        class_1309 living = (class_1309)e;
                        float strength = 1.5f;
                        double dx = living.method_23317() - this.mob.method_23317();
                        double dist = Math.sqrt(dx * dx + (dz = living.method_23321() - this.mob.method_23321()) * dz);
                        if (dist != 0.0) {
                            dx /= dist;
                            dz /= dist;
                            if (!living.method_5864().method_20210(ModTags.Entities.SOULSCORCH_ENTITIES)) {
                                living.method_5762(dx * (double)strength, 0.4 * (double)strength, dz * (double)strength);
                                living.field_6037 = true;
                                living.method_64397((class_3218)this.mob.method_37908(), this.mob.method_48923().method_48812((class_1309)this.mob), (float)this.mob.method_45325(class_5134.field_23721));
                                living.method_6092(new class_1293(ModEffects.SOULSCORCH, 600, 0, false, false, true));
                            }
                        }
                    });
                    --this.timer;
                    if (this.timer > 0) break;
                    this.state = State.DONE;
                    this.mob.setAwakened(false);
                    RestlessEntity.this.chargeDirection = null;
                    break;
                }
                case 2: {
                    this.mob.setAwakened(false);
                    RestlessEntity.this.chargeDirection = null;
                }
            }
        }

        public boolean method_6266() {
            return this.state != State.DONE;
        }

        private static enum State {
            WAITING,
            CHARGING,
            DONE;

        }
    }

    public static class InterceptHelper {
        public static class_243 computeIntercept(class_243 r0, class_243 p0, class_243 v, double s) {
            double dd;
            double C;
            double vv;
            double A;
            class_243 d = p0.method_1020(r0);
            double dv = d.method_1026(v);
            double B = 2.0 * dv;
            double disc = B * B - 4.0 * (A = (vv = v.method_1026(v)) - s * s) * (C = (dd = d.method_1026(d)));
            if (disc < 0.0 || Math.abs(A) < 1.0E-6) {
                return p0.method_1019(v.method_1021(70.0));
            }
            double sqrtDisc = Math.sqrt(disc);
            double t1 = (-B - sqrtDisc) / (2.0 * A);
            double t2 = (-B + sqrtDisc) / (2.0 * A);
            double t = Double.MAX_VALUE;
            if (t1 > 0.0) {
                t = t1;
            }
            if (t2 > 0.0 && t2 < t) {
                t = t2;
            }
            if (t == Double.MAX_VALUE) {
                return p0.method_1019(v.method_1021(70.0));
            }
            return p0.method_1019(v.method_1021(t));
        }
    }
}

