/*
 * Decompiled with CFR 0.152.
 */
package net.nullcoil.soulscorch.entity.custom;

import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8779;
import net.nullcoil.soulscorch.effect.ModEffects;
import net.nullcoil.soulscorch.entity.custom.SoulscorchFireballEntity;
import net.nullcoil.soulscorch.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class BlaztEntity
extends class_1307
implements class_1569 {
    private static final class_2940<Boolean> SHOOTING = class_2945.method_12791(BlaztEntity.class, (class_2941)class_2943.field_13323);
    private int fireballStrength = 1;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shootAnimationState = new class_7094();

    public BlaztEntity(class_1299<? extends BlaztEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 5;
        this.field_6207 = new BlaztMoveControl(this);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        float yaw = this.field_5974.method_43057() * 360.0f - 180.0f;
        this.method_36456(yaw);
        this.method_5847(yaw);
        this.method_5636(yaw);
        this.method_7217(false);
        return data;
    }

    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new FlyRandomlyGoal(this));
        this.field_6201.method_6277(7, (class_1352)new LookAtTargetGoal(this));
        this.field_6201.method_6277(6, (class_1352)new ShootFireballGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BlaztBullrushGoal(this));
        this.field_6185.method_6277(7, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (entity, world) -> Math.abs(entity.method_23318() - this.method_23318()) <= 4.0));
    }

    public boolean method_5753() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.idleAnimationState.method_41324(this.field_6012);
            if (this.isShooting()) {
                this.shootAnimationState.method_41324(this.field_6012);
            } else {
                this.shootAnimationState.method_41325();
            }
            this.spawnSmokeParticles();
        }
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public int getFireballStrength() {
        return this.fireballStrength;
    }

    protected boolean method_23734() {
        return true;
    }

    private static boolean isFireballFromPlayer(class_1282 damageSource) {
        return damageSource.method_5526() instanceof class_1674 && damageSource.method_5529() instanceof class_1657;
    }

    public boolean method_5679(class_3218 world, class_1282 source) {
        return this.method_5655() && !source.method_48789(class_8103.field_42242) || !BlaztEntity.isFireballFromPlayer(source) && super.method_5679(world, source);
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (BlaztEntity.isFireballFromPlayer(source)) {
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                class_8779 advancement = world.method_8503().method_3851().method_12896(class_2960.method_60655((String)"soulscorch", (String)"blazt_blaster"));
                if (advancement != null) {
                    serverPlayer.method_14236().method_12878(advancement, "blazt_fireball_reflect");
                }
            }
            super.method_64397(world, source, 0.0f);
            return true;
        }
        return !this.method_5679(world, source) && super.method_64397(world, source, amount);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHOOTING, (Object)false);
    }

    public static class_5132.class_5133 createBlaztAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23717, 100.0);
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected class_3414 method_5994() {
        return ModSounds.BLAZT_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.BLAZT_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.BLAZT_DEATH;
    }

    protected float method_6107() {
        return 5.0f;
    }

    public int method_5945() {
        return 1;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("ExplosionPower", (byte)this.fireballStrength);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("ExplosionPower", 99)) {
            this.fireballStrength = nbt.method_10571("ExplosionPower");
        }
    }

    private void spawnSmokeParticles() {
        if (this.method_37908().method_8608()) {
            double centerX = this.method_23317();
            double centerY = this.method_23318() + 1.0;
            double centerZ = this.method_23321();
            class_5819 random = this.method_59922();
            for (int i = 0; i < random.method_43048(2) + 2; ++i) {
                double offsetX = random.method_43058() - 0.5;
                double offsetZ = random.method_43058() - 0.5;
                double velocityX = (random.method_43058() - 0.5) * 0.02;
                double velocityY = -0.2 - random.method_43058() * 0.05;
                double velocityZ = (random.method_43058() - 0.5) * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11237, centerX + offsetX, centerY, centerZ + offsetZ, velocityX, velocityY, velocityZ);
            }
        }
    }

    static class BlaztMoveControl
    extends class_1335 {
        private final BlaztEntity blazt;
        private int collisionCheckCooldown;

        public BlaztMoveControl(BlaztEntity blazt) {
            super((class_1308)blazt);
            this.blazt = blazt;
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378 && this.collisionCheckCooldown-- <= 0) {
                this.collisionCheckCooldown += this.blazt.method_59922().method_43048(5) + 2;
                class_243 vec3d = new class_243(this.field_6370 - this.blazt.method_23317(), this.field_6369 - this.blazt.method_23318(), this.field_6367 - this.blazt.method_23321());
                double d = vec3d.method_1033();
                if (this.willCollide(vec3d = vec3d.method_1029(), class_3532.method_15384((double)d))) {
                    this.blazt.method_18799(this.blazt.method_18798().method_1019(vec3d.method_1021(0.1)));
                } else {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            }
        }

        private boolean willCollide(class_243 direction, int steps) {
            class_238 box = this.blazt.method_5829();
            for (int i = 1; i < steps; ++i) {
                box = box.method_997(direction);
                if (this.blazt.method_37908().method_8587((class_1297)this.blazt, box)) continue;
                return false;
            }
            return true;
        }
    }

    static class FlyRandomlyGoal
    extends class_1352 {
        private final BlaztEntity blazt;

        public FlyRandomlyGoal(BlaztEntity blazt) {
            this.blazt = blazt;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            double f;
            double e;
            class_1335 moveControl = this.blazt.method_5962();
            if (!moveControl.method_6241()) {
                return true;
            }
            double d = moveControl.method_6236() - this.blazt.method_23317();
            double g = d * d + (e = moveControl.method_6235() - this.blazt.method_23318()) * e + (f = moveControl.method_6237() - this.blazt.method_23321()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            class_5819 random = this.blazt.method_59922();
            double d = this.blazt.method_23317() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            double e = this.blazt.method_23318() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            double f = this.blazt.method_23321() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            this.blazt.method_5962().method_6239(d, e, f, 1.0);
        }
    }

    static class LookAtTargetGoal
    extends class_1352 {
        private final BlaztEntity blazt;

        public LookAtTargetGoal(BlaztEntity blazt) {
            this.blazt = blazt;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.blazt.method_5968() == null) {
                class_243 vec3d = this.blazt.method_18798();
                this.blazt.method_36456(-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f);
                this.blazt.field_6283 = this.blazt.method_36454();
            } else {
                class_1309 livingEntity = this.blazt.method_5968();
                if (livingEntity.method_5858((class_1297)this.blazt) < 4096.0) {
                    double e = livingEntity.method_23317() - this.blazt.method_23317();
                    double f = livingEntity.method_23321() - this.blazt.method_23321();
                    this.blazt.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                    this.blazt.field_6283 = this.blazt.method_36454();
                }
            }
        }
    }

    static class ShootFireballGoal
    extends class_1352 {
        private final BlaztEntity blazt;
        public int cooldown;

        public ShootFireballGoal(BlaztEntity blazt) {
            this.blazt = blazt;
        }

        public boolean method_6264() {
            return this.blazt.method_5968() != null;
        }

        public void method_6269() {
            this.cooldown = 0;
        }

        public void method_6270() {
            this.blazt.setShooting(false);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = this.blazt.method_5968();
            if (livingEntity != null) {
                if (livingEntity.method_5858((class_1297)this.blazt) < 4096.0 && this.blazt.method_6057((class_1297)livingEntity)) {
                    class_1937 world = this.blazt.method_37908();
                    ++this.cooldown;
                    if (this.cooldown == 10 && !this.blazt.method_5701()) {
                        world.method_43128(null, this.blazt.method_23317(), this.blazt.method_23318(), this.blazt.method_23321(), ModSounds.BLAZT_SHOOTING, class_3419.field_15251, 5.0f, 1.0f);
                    }
                    if (this.cooldown == 20) {
                        class_243 vec3d = this.blazt.method_5828(1.0f);
                        double f = livingEntity.method_23317() - (this.blazt.method_23317() + vec3d.field_1352 * 4.0);
                        double g = livingEntity.method_23323(0.5) - (0.5 + this.blazt.method_23323(0.5));
                        double h = livingEntity.method_23321() - (this.blazt.method_23321() + vec3d.field_1350 * 4.0);
                        class_243 vec3d2 = new class_243(f, g, h);
                        if (!this.blazt.method_5701()) {
                            world.method_43128(null, this.blazt.method_23317(), this.blazt.method_23318(), this.blazt.method_23321(), ModSounds.BLAZT_SOUL_CHARGE, class_3419.field_15251, 5.0f, 1.0f);
                        }
                        if (this.blazt.method_59922().method_43056()) {
                            SoulscorchFireballEntity fireballEntity = new SoulscorchFireballEntity(world, (class_1309)this.blazt, vec3d2.method_1029());
                            fireballEntity.method_5814(this.blazt.method_23317() + vec3d.field_1352 * 4.0, this.blazt.method_23323(0.5) + 0.5, this.blazt.method_23321() + vec3d.field_1350 * 4.0);
                            world.method_8649((class_1297)fireballEntity);
                        } else {
                            class_1674 fireballEntity = new class_1674(world, (class_1309)this.blazt, vec3d2.method_1029(), this.blazt.getFireballStrength());
                            fireballEntity.method_5814(this.blazt.method_23317() + vec3d.field_1352 * 4.0, this.blazt.method_23323(0.5) + 0.5, this.blazt.method_23321() + vec3d.field_1350 * 4.0);
                            world.method_8649((class_1297)fireballEntity);
                        }
                        this.cooldown = -40;
                    }
                } else if (this.cooldown > 0) {
                    --this.cooldown;
                }
                this.blazt.setShooting(this.cooldown > 10);
            }
        }
    }

    static class BlaztBullrushGoal
    extends class_1352 {
        private final BlaztEntity blazt;
        private int cooldown = 0;
        private int rushTicks = 0;
        private class_243 rushDirection = class_243.field_1353;
        private static final double RUSH_SPEED = 1.2;
        private static final int MAX_RUSH_DISTANCE = 100;
        private static final int RUSH_DURATION = 100;

        public BlaztBullrushGoal(BlaztEntity blazt) {
            this.blazt = blazt;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.blazt.method_5968() != null && this.cooldown <= 0;
        }

        public void method_6269() {
            class_1309 target = this.blazt.method_5968();
            if (target == null) {
                return;
            }
            double distanceSq = this.blazt.method_5858((class_1297)target);
            if (distanceSq <= 10000.0) {
                this.rushTicks = 100;
                this.spawnSoulFireParticles();
                if (!this.blazt.method_37908().method_8608()) {
                    this.blazt.method_37908().method_43128(null, this.blazt.method_23317(), this.blazt.method_23318(), this.blazt.method_23321(), ModSounds.BLAZT_BREATHE_IN, class_3419.field_15251, 5.0f, 1.0f);
                }
                this.rushDirection = target.method_19538().method_1020(this.blazt.method_19538()).method_1029();
            } else {
                this.blazt.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 0.8);
                this.rushTicks = 0;
            }
        }

        public boolean method_6266() {
            return this.rushTicks > 0;
        }

        public void method_6268() {
            class_1309 target = this.blazt.method_5968();
            if (this.rushTicks > 0 && target != null) {
                class_1937 class_19372;
                --this.rushTicks;
                this.blazt.method_18799(this.rushDirection.method_1021(1.2));
                this.blazt.field_6037 = true;
                if (this.blazt.method_5829().method_994(target.method_5829()) && (class_19372 = this.blazt.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1282 source = serverWorld.method_48963().method_48812((class_1309)this.blazt);
                    target.method_64397(serverWorld, source, 8.0f);
                    if (target instanceof class_1309) {
                        class_1309 living = target;
                        living.method_6092(new class_1293(ModEffects.SOULSCORCH, 600, 0));
                        target.method_5762(this.rushDirection.field_1352 * 1.5, 0.4, this.rushDirection.field_1350 * 1.5);
                        target.field_6037 = true;
                    }
                    this.endRush();
                }
                if (this.rushTicks <= 0) {
                    this.endRush();
                }
            }
        }

        private void endRush() {
            this.blazt.method_6092(new class_1293(class_1294.field_5909, 40, 0));
            if (!this.blazt.method_37908().method_8608()) {
                this.blazt.method_37908().method_43128(null, this.blazt.method_23317(), this.blazt.method_23318(), this.blazt.method_23321(), ModSounds.BLAZT_BREATHE_OUT, class_3419.field_15251, 5.0f, 1.0f);
            }
            this.cooldown = 300;
            this.rushTicks = 0;
        }

        private void spawnSoulFireParticles() {
            if (!this.blazt.method_37908().method_8608()) {
                return;
            }
            double cx = this.blazt.method_23317();
            double cy = this.blazt.method_23318() + 1.0;
            double cz = this.blazt.method_23321();
            int count = 16;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)count;
                double radius = 1.0;
                double px = cx + Math.cos(angle) * radius;
                double pz = cz + Math.sin(angle) * radius;
                this.blazt.method_37908().method_8406((class_2394)class_2398.field_22246, px, cy, pz, 0.0, 0.05, 0.0);
            }
        }
    }
}

