/*
 * Decompiled with CFR 0.152.
 */
package net.nullcoil.soulscorch.entity.custom;

import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1368;
import net.minecraft.class_1394;
import net.minecraft.class_1396;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1590;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import net.minecraft.class_7184;
import net.nullcoil.soulscorch.effect.ModEffects;
import net.nullcoil.soulscorch.entity.client.soulless.SoullessActivity;
import net.nullcoil.soulscorch.entity.client.soulless.SoullessAnimations;
import net.nullcoil.soulscorch.sound.ModSounds;
import net.nullcoil.soulscorch.util.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoullessEntity
extends class_1590
implements class_5354 {
    @Nullable
    private UUID angryAt;
    private int angerTime = 1200;
    private static final class_6019 ANGER_TIME_RANGE;
    private class_7184 currentAnimation;
    private int ticksUntilNext = 0;
    private int twitchDuration = 0;
    private static final Random RANDOM;
    public final class_7094 passiveAnimationState = new class_7094();
    public final class_7094 neutralAnimationState = new class_7094();
    public final class_7094 hostileAnimationState = new class_7094();
    private static final class_2940<Integer> ACTIVITY;

    protected float method_23326() {
        class_2680 blockState = this.method_37908().method_8320(this.method_23314());
        if (blockState.method_26164(ModTags.Blocks.SOULBASED_BLOCKS)) {
            return 1.2f;
        }
        return super.method_23326();
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        float yaw = this.field_5974.method_43057() * 360.0f - 180.0f;
        this.method_36456(yaw);
        this.method_5847(yaw);
        this.method_5636(yaw);
        this.method_7217(false);
        return data;
    }

    public SoullessEntity(class_1299<? extends class_1590> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ACTIVITY, (Object)SoullessActivity.PASSIVE.getId());
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1590.method_26941().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 35.0);
    }

    public SoullessActivity getActivity() {
        return SoullessActivity.values()[(Integer)this.field_6011.method_12789(ACTIVITY)];
    }

    public void setActivity(@NotNull SoullessActivity activity) {
        this.field_6011.method_12778(ACTIVITY, (Object)activity.getId());
        this.field_6201.method_35113(goal -> true);
        this.field_6185.method_35113(goal -> true);
        switch (activity) {
            case PASSIVE: {
                break;
            }
            case NEUTRAL: {
                this.field_6201.method_6277(7, (class_1352)new LookAtTargetGoal(this, 0.0));
                this.field_6185.method_6277(7, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
                break;
            }
            case HOSTILE: {
                this.field_6201.method_6277(2, (class_1352)new class_1396((class_1642)this, 1.0, false));
                this.field_6201.method_6277(6, (class_1352)new class_1368((class_1314)this, 1.0, true, 4, () -> ((SoullessEntity)this).method_7211()));
                this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
                this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{class_1590.class}));
                this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
            }
        }
    }

    public void raiseActivity() {
        switch (this.getActivity()) {
            case PASSIVE: {
                this.method_56078(ModSounds.SOULLESS_WAKE);
                this.setActivity(SoullessActivity.NEUTRAL);
                break;
            }
            case NEUTRAL: {
                this.method_56078(ModSounds.SOULLESS_WAKE);
                this.setActivity(SoullessActivity.HOSTILE);
                break;
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.twitchDuration > 0) {
            --this.twitchDuration;
        }
        if (this.ticksUntilNext > 0) {
            --this.ticksUntilNext;
        } else {
            switch (this.getActivity()) {
                case PASSIVE: {
                    this.currentAnimation = SoullessAnimations.PASSIVE;
                    break;
                }
                case NEUTRAL: {
                    this.currentAnimation = SoullessAnimations.NEUTRAL();
                    break;
                }
            }
            if (this.currentAnimation != null) {
                this.twitchDuration = (int)(this.currentAnimation.comp_597() * 20.0f);
            }
            this.ticksUntilNext = 40;
        }
        if (this.method_37908().method_8608()) {
            this.passiveAnimationState.method_41325();
            this.neutralAnimationState.method_41325();
            this.hostileAnimationState.method_41325();
            switch (this.getActivity()) {
                case PASSIVE: {
                    this.passiveAnimationState.method_41324(this.field_6012);
                    break;
                }
                case NEUTRAL: {
                    this.neutralAnimationState.method_41324(this.field_6012);
                    break;
                }
                case HOSTILE: {
                    this.hostileAnimationState.method_41324(this.field_6012);
                }
            }
        }
        if (this.method_37908() instanceof class_3218) {
            switch (this.getActivity()) {
                case NEUTRAL: {
                    if (this.method_5968() == null || this.method_6057((class_1297)this.method_5968())) break;
                    this.setActivity(SoullessActivity.PASSIVE);
                    break;
                }
                case HOSTILE: {
                    if (this.angerTime > 0) {
                        --this.angerTime;
                    }
                    if (this.angerTime > 0) break;
                    this.setActivity(SoullessActivity.NEUTRAL);
                    this.angerTime = 1200;
                }
            }
        }
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        boolean bl = super.method_6121(world, target);
        if (bl && target instanceof class_1309) {
            float f = this.method_37908().method_8404(this.method_24515()).method_5457();
            ((class_1309)target).method_6092(new class_1293(ModEffects.SOULSCORCH, 600, 0, false, false, true));
            this.angerTime = 1200;
        }
        return bl;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        boolean wasDamaged = super.method_64397(world, source, amount);
        if (wasDamaged && this.getActivity() != SoullessActivity.HOSTILE && source.method_5529() instanceof class_1657) {
            this.setActivity(SoullessActivity.HOSTILE);
        }
        return wasDamaged;
    }

    public class_7184 getCurrentAnimation() {
        return this.currentAnimation;
    }

    public boolean method_5753() {
        return true;
    }

    protected void method_5959() {
        switch (this.getActivity()) {
            case PASSIVE: {
                break;
            }
            case NEUTRAL: {
                this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
                break;
            }
            case HOSTILE: {
                this.field_6201.method_6277(2, (class_1352)new class_1396((class_1642)this, 1.0, false));
                this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
                this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
            }
        }
        this.field_6185.method_6277(1, (class_1352)new SoullessRevengeGoal(this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (arg_0, arg_1) -> ((SoullessEntity)this).method_29515(arg_0, arg_1)));
    }

    public boolean method_18395(class_1309 target) {
        if (this.getActivity() == SoullessActivity.PASSIVE) {
            return false;
        }
        return super.method_18395(target);
    }

    public int method_29507() {
        return 0;
    }

    public void method_29514(int angerTime) {
        ANGER_TIME_RANGE.method_35008(this.field_5974);
    }

    @Nullable
    public UUID method_29508() {
        return null;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public class_3419 method_5634() {
        return class_3419.field_15254;
    }

    public class_3414 method_5994() {
        switch (this.getActivity()) {
            case NEUTRAL: {
                return ModSounds.SOULLESS_AMBIENT;
            }
            case HOSTILE: {
                return ModSounds.SOULLESS_ANGRY;
            }
        }
        return (class_3414)class_3417.field_23060.comp_349();
    }

    public class_3414 method_6011(class_1282 source) {
        return ModSounds.SOULLESS_HURT;
    }

    public class_3414 method_6002() {
        return ModSounds.SOULLESS_DEATH;
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
    }

    static {
        RANDOM = new Random();
        ACTIVITY = class_2945.method_12791(SoullessEntity.class, (class_2941)class_2943.field_13327);
        ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    }

    static class LookAtTargetGoal
    extends class_1396 {
        public LookAtTargetGoal(SoullessEntity soulless, double speed) {
            super((class_1642)soulless, speed, false);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            class_1309 target = this.field_6503.method_5968();
            this.field_6503.method_5942().method_6340();
            if (target != null && !target.method_31481()) {
                double dx = target.method_23317() - this.field_6503.method_23317();
                double dz = target.method_23321() - this.field_6503.method_23321();
                float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                this.field_6503.method_36456(yaw);
                this.field_6503.method_5636(yaw);
                this.field_6503.method_5847(yaw);
            }
        }
    }

    static class SoullessRevengeGoal
    extends class_1399 {
        public SoullessRevengeGoal(SoullessEntity mob, Class<?> ... noRevengeTypes) {
            super((class_1314)mob, (Class[])noRevengeTypes);
        }

        public void method_6269() {
            super.method_6269();
            class_1308 class_13082 = this.field_6660;
            if (class_13082 instanceof SoullessEntity) {
                SoullessEntity soulless = (SoullessEntity)class_13082;
                soulless.setActivity(SoullessActivity.HOSTILE);
            }
        }
    }
}

