/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.yaml.snakeyaml.Yaml;

@Environment(value=EnvType.CLIENT)
public class Block4BlockModClient
implements ClientModInitializer {
    private final Set<class_2248> blockForBlockBlocks = new HashSet<class_2248>();
    private final Set<class_2960> freeToBreakIds = new HashSet<class_2960>();
    private final Set<class_2960> freeInClaimsIds = new HashSet<class_2960>();
    private boolean useAdvancedTooltip = true;
    private boolean useLore = false;
    private String blockForBlockText = "\u00a7cBlock for Block";
    private String freeToBreakText = "\u00a7aFree to Break";
    private String freeInClaimsText = "\u00a7bFree in Claims";
    private static final String BLOCK_LISTS_FILE = "block_lists.yml";
    private static final String CONFIG_FILE = "config.yml";

    private void createDefaultConfig() {
        Path configPath = Path.of(FabricLoader.getInstance().getConfigDirectory().toString(), CONFIG_FILE);
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.writeString(configPath, (CharSequence)CONFIG_FILE, StandardOpenOption.CREATE);
                System.out.println("Default config.yml created.");
            }
            catch (IOException e) {
                System.err.println("Error creating default config.yml: " + e.getMessage());
            }
        }
    }

    private void createDefaultBlockLists() {
        Path blockListsPath = Path.of(FabricLoader.getInstance().getConfigDirectory().toString(), BLOCK_LISTS_FILE);
        if (Files.notExists(blockListsPath, new LinkOption[0])) {
            try {
                Files.writeString(blockListsPath, (CharSequence)BLOCK_LISTS_FILE, StandardOpenOption.CREATE);
                System.out.println("Default block_lists.yml created.");
            }
            catch (IOException e) {
                System.err.println("Error creating default block_lists.yml: " + e.getMessage());
            }
        }
    }

    public void onInitializeClient() {
        System.out.println("BlockStatus Client Mod Initializer loaded!");
        this.createDefaultConfig();
        this.createDefaultBlockLists();
        this.loadConfig();
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltipType, list) -> {
            class_1792 item = itemStack.method_7909();
            if (!(item instanceof class_1747)) {
                return;
            }
            class_2248 block = ((class_1747)item).method_7711();
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            if (this.freeToBreakIds.contains(id)) {
                this.addTooltip(list, this.freeToBreakText);
            } else if (this.freeInClaimsIds.contains(id)) {
                this.addTooltip(list, this.freeInClaimsText);
            } else if (this.blockForBlockBlocks.contains(block)) {
                this.addTooltip(list, this.blockForBlockText);
            }
        });
    }

    private void addTooltip(List<class_2561> tooltipList, String tooltipText) {
        tooltipList.add((class_2561)class_2561.method_43470((String)tooltipText));
    }

    private void loadConfig() {
        InputStream blockListsStream = Block4BlockModClient.class.getResourceAsStream("/block_lists.yml");
        if (blockListsStream != null) {
            this.loadBlockLists(blockListsStream);
        } else {
            System.err.println("Error: block_lists.yml not found in resources.");
        }
        InputStream configStream = Block4BlockModClient.class.getResourceAsStream("/config.yml");
        if (configStream != null) {
            this.loadConfigFile(configStream);
        } else {
            System.err.println("Error: config.yml not found in resources.");
        }
        for (class_2248 block : class_7923.field_41175) {
            class_2960 id2;
            if (!(block.method_8389() instanceof class_1747) || this.freeToBreakIds.contains(id2 = class_7923.field_41175.method_10221((Object)block)) || this.freeInClaimsIds.contains(id2)) continue;
            this.blockForBlockBlocks.add(block);
        }
        System.out.println("Free in claims blocks loaded:");
        this.freeInClaimsIds.forEach(id -> System.out.println(" - " + String.valueOf(id)));
        System.out.println("Free to break blocks loaded:");
        this.freeToBreakIds.forEach(id -> System.out.println(" - " + String.valueOf(id)));
        System.out.println("BlockStatus: Loaded " + this.blockForBlockBlocks.size() + " Block for Block blocks, " + this.freeToBreakIds.size() + " free to break blocks, " + this.freeInClaimsIds.size() + " free in claims blocks");
    }

    private void loadConfigFile(InputStream configStream) {
        Yaml yaml = new Yaml();
        try (InputStreamReader reader = new InputStreamReader(configStream);){
            Map config = (Map)yaml.load((Reader)reader);
            if (config != null) {
                if (config.containsKey("display")) {
                    Map display = (Map)config.get("display");
                    this.useAdvancedTooltip = display.getOrDefault("useAdvancedTooltip", true);
                    this.useLore = display.getOrDefault("useLore", false);
                    this.blockForBlockText = display.getOrDefault("blockForBlockText", "\u00a7cBlock for Block");
                    this.freeToBreakText = display.getOrDefault("freeToBreakText", "\u00a7aFree to Break");
                    this.freeInClaimsText = display.getOrDefault("freeInClaimsText", "\u00a7bFree in Claims");
                }
                System.out.println("Config loaded:");
                System.out.println(" - useAdvancedTooltip: " + this.useAdvancedTooltip);
                System.out.println(" - useLore: " + this.useLore);
                System.out.println(" - blockForBlockText: " + this.blockForBlockText);
                System.out.println(" - freeToBreakText: " + this.freeToBreakText);
                System.out.println(" - freeInClaimsText: " + this.freeInClaimsText);
            } else {
                System.err.println("Error: config.yml is empty or not correctly formatted.");
            }
        }
        catch (IOException e) {
            System.err.println("Error loading config.yml from resources: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadBlockLists(InputStream blockListsStream) {
        Yaml yaml = new Yaml();
        try (InputStreamReader reader = new InputStreamReader(blockListsStream);){
            Map lists = (Map)yaml.load((Reader)reader);
            this.freeInClaimsIds.clear();
            this.freeToBreakIds.clear();
            this.blockForBlockBlocks.clear();
            List<String> claimBlocks = this.getListFromConfig(lists, "blacklisted-claim-blocks");
            List<String> breakBlocks = this.getListFromConfig(lists, "blacklisted-blocks");
            this.loadBlockListFromIds(claimBlocks, this.freeInClaimsIds);
            this.loadBlockListFromIds(breakBlocks, this.freeToBreakIds);
        }
        catch (IOException e) {
            System.err.println("Error loading block lists from resources: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadBlockListFromIds(List<String> blockIds, Set<class_2960> idSet) {
        for (String blockId : blockIds) {
            try {
                class_2960 id = class_2960.method_12829((String)blockId);
                if (id == null) {
                    System.err.println("Invalid block ID format: " + blockId);
                    continue;
                }
                class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
                if (block != null && block.method_8389() instanceof class_1747) {
                    idSet.add(id);
                    System.out.println("Successfully added block: " + String.valueOf(id));
                    continue;
                }
                System.out.println("Block " + String.valueOf(id) + " is unknown or not placeable and will not be added.");
            }
            catch (Exception e) {
                System.err.println("Error processing block ID: " + blockId);
                e.printStackTrace();
            }
        }
    }

    private List<String> getListFromConfig(Map<String, Object> config, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (config.containsKey(key)) {
            Object obj = config.get(key);
            if (obj instanceof List) {
                for (Object item : (List)obj) {
                    if (item instanceof String) {
                        result.add((String)item);
                        continue;
                    }
                    System.err.println("Invalid item in list for key " + key + ": " + String.valueOf(item));
                }
            } else {
                System.err.println("Value for key " + key + " is not a list.");
            }
        } else {
            System.err.println("Key " + key + " not found in config.");
        }
        return result;
    }
}

