/*
 * Decompiled with CFR 0.152.
 */
package net.erbium.moreyes.item;

import net.erbium.moreyes.util.StructureTags;
import net.minecraft.advancement.criterion.Criteria;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EyeOfEnderEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUsageContext;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvents;
import net.minecraft.stat.Stats;
import net.minecraft.state.property.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.hit.HitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.RaycastContext;
import net.minecraft.world.World;
import net.minecraft.world.WorldAccess;
import net.minecraft.world.WorldView;
import net.minecraft.world.event.GameEvent;

public class EyeOfFortressItem
extends Item {
    public EyeOfFortressItem(Item.Settings settings) {
        super(settings);
    }

    public ActionResult useOnBlock(ItemUsageContext context) {
        BlockPos blockPos;
        World world = context.getWorld();
        BlockState blockState = world.getBlockState(blockPos = context.getBlockPos());
        if (blockState.isOf(Blocks.END_PORTAL_FRAME) && !((Boolean)blockState.get((Property)EndPortalFrameBlock.EYE)).booleanValue()) {
            if (world.isClient()) {
                return ActionResult.SUCCESS;
            }
            BlockState blockState2 = (BlockState)blockState.with((Property)EndPortalFrameBlock.EYE, (Comparable)Boolean.valueOf(true));
            Block.pushEntitiesUpBeforeBlockChange((BlockState)blockState, (BlockState)blockState2, (WorldAccess)world, (BlockPos)blockPos);
            world.setBlockState(blockPos, blockState2, 2);
            world.updateComparators(blockPos, Blocks.END_PORTAL_FRAME);
            context.getStack().decrement(1);
            world.syncWorldEvent(1503, blockPos, 0);
            BlockPattern.Result result = EndPortalFrameBlock.getCompletedFramePattern().searchAround((WorldView)world, blockPos);
            if (result != null) {
                BlockPos blockPos2 = result.getFrontTopLeft().add(-3, 0, -3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        BlockPos blockPos3 = blockPos2.add(i, 0, j);
                        world.breakBlock(blockPos3, true, (Entity)null);
                        world.setBlockState(blockPos3, Blocks.END_PORTAL.getDefaultState(), 2);
                    }
                }
                world.syncGlobalEvent(1038, blockPos2.add(1, 0, 1), 0);
            }
            return ActionResult.SUCCESS;
        }
        return ActionResult.PASS;
    }

    public int getMaxUseTime(ItemStack stack, LivingEntity user) {
        return 0;
    }

    public ActionResult use(World world, PlayerEntity user, Hand hand) {
        ItemStack itemStack = user.getStackInHand(hand);
        BlockHitResult blockHitResult = EyeOfFortressItem.raycast((World)world, (PlayerEntity)user, (RaycastContext.FluidHandling)RaycastContext.FluidHandling.NONE);
        if (blockHitResult.getType() == HitResult.Type.BLOCK && world.getBlockState(blockHitResult.getBlockPos()).isOf(Blocks.END_PORTAL_FRAME)) {
            return ActionResult.PASS;
        }
        user.setCurrentHand(hand);
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            BlockPos blockPos = serverWorld.locateStructure(StructureTags.Structures.EYE_OF_FORTRESS_LOCATED, user.getBlockPos(), 100, false);
            if (blockPos == null) {
                return ActionResult.CONSUME;
            }
            EyeOfEnderEntity eyeOfEnderEntity = new EyeOfEnderEntity(world, user.getX(), user.getBodyY(0.5), user.getZ());
            eyeOfEnderEntity.setItem(itemStack);
            eyeOfEnderEntity.initTargetPos(Vec3d.of((Vec3i)blockPos));
            world.emitGameEvent((RegistryEntry)GameEvent.PROJECTILE_SHOOT, eyeOfEnderEntity.getEntityPos(), GameEvent.Emitter.of((Entity)user));
            world.spawnEntity((Entity)eyeOfEnderEntity);
            if (user instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)user;
                Criteria.USED_ENDER_EYE.trigger(serverPlayerEntity, blockPos);
            }
            float f = MathHelper.lerp((float)world.random.nextFloat(), (float)0.33f, (float)0.5f);
            world.playSound((Entity)null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENTITY_ENDER_EYE_LAUNCH, SoundCategory.NEUTRAL, 1.0f, f);
            itemStack.decrementUnlessCreative(1, (LivingEntity)user);
            user.incrementStat(Stats.USED.getOrCreateStat((Object)this));
        }
        return ActionResult.SUCCESS_SERVER;
    }
}

