/*
 * Decompiled with CFR 0.152.
 */
package Jarno.coremod.ranks;

import Jarno.coremod.ranks.IRank;
import Jarno.coremod.ranks.RankManager;
import Jarno.coremod.ranks.RankProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandRank
extends CommandBase {
    public String func_71517_b() {
        return "rank";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rank <add|get|remove|create|list|delete>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank <add|get|remove|create|list|delete>"));
            return;
        }
        String action = args[0];
        switch (action.toLowerCase()) {
            case "add": {
                if (args.length < 3) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank add <player> <rank>"));
                    return;
                }
                this.handleAdd(server, sender, args[1], args[2]);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank remove <player>"));
                    return;
                }
                this.handleRemove(server, sender, args[1]);
                break;
            }
            case "get": {
                if (args.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank get <player>"));
                    return;
                }
                this.handleGet(server, sender, args[1]);
                break;
            }
            case "create": {
                if (args.length < 3) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank create <rank> <value>"));
                    return;
                }
                this.handleCreate(sender, args[1], args[2]);
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /rank delete <rank>"));
                    return;
                }
                this.handleDelete(sender, args[1]);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentString("Unknown subcommand."));
            }
        }
    }

    private void handleAdd(MinecraftServer server, ICommandSender sender, String playerName, String rankName) {
        if (playerName.startsWith("@")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Selectors like '@a' are not supported. Use exact player names."));
            return;
        }
        if (!RankManager.isValidRank(rankName)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Rank '" + rankName + "' does not exist."));
            return;
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player '" + playerName + "' not found."));
            return;
        }
        IRank cap = (IRank)player.getCapability(RankProvider.RANK_CAP, null);
        if (cap != null) {
            cap.setRank(rankName);
            cap.setValue(RankManager.getRankXP(rankName));
            sender.func_145747_a((ITextComponent)new TextComponentString("Set rank of " + player.func_70005_c_() + " to " + rankName + "."));
        }
    }

    private void handleRemove(MinecraftServer server, ICommandSender sender, String playerName) {
        if (playerName.startsWith("@")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Selectors like '@a' are not supported. Use exact player names."));
            return;
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player '" + playerName + "' not found."));
            return;
        }
        IRank cap = (IRank)player.getCapability(RankProvider.RANK_CAP, null);
        if (cap != null) {
            cap.setRank("");
            cap.setValue(0);
            sender.func_145747_a((ITextComponent)new TextComponentString("Removed rank of " + player.func_70005_c_() + "."));
        }
    }

    private void handleGet(MinecraftServer server, ICommandSender sender, String playerName) {
        if (playerName.startsWith("@")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Selectors like '@a' are not supported. Use exact player names."));
            return;
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player '" + playerName + "' not found."));
            return;
        }
        IRank cap = (IRank)player.getCapability(RankProvider.RANK_CAP, null);
        if (cap != null && cap.getRank() != null && !cap.getRank().isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " has rank: " + cap.getRank() + " (" + cap.getValue() + " NXP)"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " has no rank."));
        }
    }

    private void handleCreate(ICommandSender sender, String rankName, String valueStr) {
        try {
            int value = Integer.parseInt(valueStr);
            if (RankManager.isValidRank(rankName)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Rank '" + rankName + "' already exists."));
                return;
            }
            RankManager.getRanks().put(rankName, value);
            RankManager.saveRanks();
            sender.func_145747_a((ITextComponent)new TextComponentString("Created new rank '" + rankName + "' with value " + value + "."));
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid value: " + valueStr));
        }
    }

    private void handleDelete(ICommandSender sender, String rankName) {
        if (!RankManager.isValidRank(rankName)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Rank '" + rankName + "' does not exist."));
            return;
        }
        RankManager.getRanks().remove(rankName);
        RankManager.saveRanks();
        sender.func_145747_a((ITextComponent)new TextComponentString("Deleted rank '" + rankName + "'."));
    }

    private void handleList(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Available Ranks:"));
        for (Map.Entry<String, Integer> entry : RankManager.getRanks().entrySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("- " + entry.getKey() + " (" + entry.getValue() + " NXP)"));
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandRank.func_71530_a((String[])args, (String[])new String[]{"add", "get", "remove", "create", "list", "delete"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("get")) {
                return CommandRank.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args[0].equalsIgnoreCase("delete")) {
                return CommandRank.func_175762_a((String[])args, RankManager.getRanks().keySet());
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("add")) {
            return CommandRank.func_175762_a((String[])args, RankManager.getRanks().keySet());
        }
        return Collections.emptyList();
    }
}

