/*
 * Decompiled with CFR 0.152.
 */
package Jarno.coremod.ranks;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class RankManager {
    private static final Gson gson = new Gson();
    private static Map<String, Integer> ranks = new HashMap<String, Integer>();
    private static File worldRanksFile;

    public static void loadRanks(World world) {
        try {
            worldRanksFile = new File(world.func_72860_G().func_75765_b(), "BattleProgression/ranks.json");
            if (worldRanksFile.exists()) {
                FileReader reader = new FileReader(worldRanksFile);
                Type type = new TypeToken<Map<String, Integer>>(){}.getType();
                Map loadedRanks = (Map)gson.fromJson((Reader)reader, type);
                if (loadedRanks != null) {
                    ranks.clear();
                    ranks.putAll(loadedRanks);
                }
                ((Reader)reader).close();
            } else {
                ranks.clear();
                ranks.put("Genin", 50000);
                ranks.put("Chuunin", 80000);
                ranks.put("Jonin", 120000);
                ranks.put("Kage", 160000);
                RankManager.saveRanks();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveRanks() {
        try {
            if (worldRanksFile != null) {
                if (!worldRanksFile.getParentFile().exists()) {
                    worldRanksFile.getParentFile().mkdirs();
                }
                FileWriter writer = new FileWriter(worldRanksFile);
                gson.toJson(ranks, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isValidRank(String rankName) {
        return ranks.containsKey(rankName);
    }

    public static int getRankXP(String rankName) {
        return ranks.getOrDefault(rankName, 0);
    }

    public static Map<String, Integer> getRanks() {
        return ranks;
    }
}

