{
    runMegaEvo(pokemon) {
        const speciesid = pokemon.canMegaEvo || pokemon.canUltraBurst;
        if (!speciesid) return false;

         if (pokemon.ability === 'aurabreak') {
            this.battle.add('-hint', 'Zygarde cannot Mega Evolve while it has Aura Break!');
            return false;
        }

        const isZygardeMega = speciesid === "Zygarde-Mega";

        if (isZygardeMega) {
            const coreIndex = pokemon.moveSlots.findIndex(m => m.id === "coreenforcer");
            if (coreIndex >= 0) {
                const nihilLight = this.battle.dex.moves.get("nihillight");
            
                const slot = pokemon.moveSlots[coreIndex];
                slot.id = nihilLight.id;
                slot.move = nihilLight.name;
                slot.pp = nihilLight.pp;
                slot.maxpp = nihilLight.pp;
            
                const baseSlot = pokemon.baseMoveSlots[coreIndex];
                baseSlot.id = nihilLight.id;
                baseSlot.move = nihilLight.name;
                baseSlot.pp = nihilLight.pp;
                baseSlot.maxpp = nihilLight.pp;
            
                slot.used = false;
            }
        }

        pokemon.formeChange(speciesid, pokemon.getItem(), true);

        const wasMega = pokemon.canMegaEvo;
        for (const ally of pokemon.side.pokemon) {
            if (wasMega) ally.canMegaEvo = null;
            else ally.canUltraBurst = null;
        }

        this.battle.runEvent("AfterMega", pokemon);

        return true;
    },
    canMegaEvo(pokemon) {
        const species = pokemon.species;
        if (pokemon.ability === 'aurabreak') return null;
        const item = pokemon.getItem();
        if (
          species.baseSpecies === "Rayquaza" &&
          (pokemon.terastallized || pokemon.getItem().zMove)
        ) {
          return null;
        }
        if (
          species.baseSpecies === "Rayquaza" &&
          pokemon.baseMoves.includes("dragonascent")
        ) {
          return "Rayquaza-Mega";
        }
        const megaKey = species.otherFormes?.find((form) =>
          /.*-Mega(-[a-zA-Z])?/.test(form)
        );
        const megaForme = megaKey && this.dex.species.get(megaKey);
        if (
          (this.battle.gen <= 7 || this.battle.ruleTable.has("+pokemontag:past")) &&
          megaForme?.requiredMove &&
          pokemon.baseMoves.includes(
            (0, import_dex.toID)(megaForme.requiredMove)
          ) &&
          !item.zMove
        ) {
          return megaForme.name;
        }
        if (
          item.megaEvolves?.includes(species.name) &&
          item.megaStone !== species.name
        ) {
          return item.megaStone;
        }
        return null;
    }

}