/*
 * Decompiled with CFR 0.152.
 */
package us.kenny.mixin;

import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import us.kenny.MultiKeyBindingManager;
import us.kenny.core.MultiKeyBinding;
import us.kenny.core.StickyMultiKeyBinding;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_304.class})
public abstract class KeyBindingMixin {
    @Shadow
    public abstract String method_1431();

    @Shadow
    public abstract String method_1423();

    @Inject(method={"onKeyPressed"}, at={@At(value="TAIL")})
    private static void onOnKeyPressed(class_3675.class_306 key, CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(key);
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            multiKeyBinding.incrementTimesPressed();
        }
    }

    @Inject(method={"setKeyPressed"}, at={@At(value="TAIL")})
    private static void onSetKeyPressed(class_3675.class_306 key, boolean pressed, CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(key);
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            multiKeyBinding.setPressed(pressed);
        }
    }

    @Inject(method={"updatePressedStates"}, at={@At(value="TAIL")})
    private static void onUpdatedPressedStates(CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings();
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            if (multiKeyBinding.getKey().method_1442() != class_3675.class_307.field_1668 || multiKeyBinding.getKey().method_1444() == class_3675.field_16237.method_1444()) continue;
            multiKeyBinding.setPressed(class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)multiKeyBinding.getKey().method_1444()));
        }
    }

    @Inject(method={"unpressAll"}, at={@At(value="TAIL")})
    private static void onUnpressAll(CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings();
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            multiKeyBinding.reset();
        }
    }

    @Inject(method={"untoggleStickyKeys"}, at={@At(value="TAIL")})
    private static void onUntoggleStickyKeys(CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings();
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            if (!(multiKeyBinding instanceof StickyMultiKeyBinding)) continue;
            StickyMultiKeyBinding stickyMultiKeyBinding = (StickyMultiKeyBinding)multiKeyBinding;
            stickyMultiKeyBinding.untoggle();
        }
    }

    @Inject(method={"isPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPressed(CallbackInfoReturnable<Boolean> cir) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(this.method_1431());
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            if (!multiKeyBinding.getPressed()) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(method={"wasPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onWasPressed(CallbackInfoReturnable<Boolean> cir) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(this.method_1431());
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            if (multiKeyBinding.getTimesPressed() == 0) continue;
            multiKeyBinding.decrementTimesPressed();
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(method={"reset"}, at={@At(value="TAIL")})
    private static void onReset(CallbackInfo ci) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings();
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            multiKeyBinding.reset();
        }
    }

    @Inject(method={"matchesKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMatchesKey(int keyCode, int scanCode, CallbackInfoReturnable<Boolean> cir) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(this.method_1431());
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            class_3675.class_306 key = multiKeyBinding.getKey();
            boolean bl = keyCode == class_3675.field_16237.method_1444() ? key.method_1442() == class_3675.class_307.field_1671 && key.method_1444() == scanCode : key.method_1442() == class_3675.class_307.field_1668 && key.method_1444() == keyCode;
            boolean matches = bl;
            if (!matches) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(method={"matchesMouse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMatchesMouse(int code, CallbackInfoReturnable<Boolean> cir) {
        Collection<MultiKeyBinding> multiKeyBindings = MultiKeyBindingManager.getKeyBindings(this.method_1431());
        for (MultiKeyBinding multiKeyBinding : multiKeyBindings) {
            class_3675.class_306 key = multiKeyBinding.getKey();
            boolean matches = key.method_1442() == class_3675.class_307.field_1672 && key.method_1444() == code;
            if (!matches) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }
}

