/*
 * Decompiled with CFR 0.152.
 */
package us.kenny;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3675;
import us.kenny.MultiKeyBindingClient;
import us.kenny.MultiKeyBindingManager;
import us.kenny.core.MultiKeyBinding;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    public static final int CONFIG_VERSION = 2;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("multi-key-bindings.json");
    private static final Gson GSON = new Gson();
    public static boolean isLoading = false;

    public static void saveConfigFile() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            JsonObject json = new JsonObject();
            JsonArray keyBindingsArray = ConfigManager.getFormattedKeyBindings();
            json.addProperty("config_version", (Number)2);
            json.add("bindings", (JsonElement)keyBindingsArray);
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            MultiKeyBindingClient.LOGGER.error("Failed to save keybindings config", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadConfigFile() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            return;
        }
        boolean migrated = false;
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            int version;
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json == null) {
                return;
            }
            int n = version = json.has("config_version") ? json.get("config_version").getAsInt() : 1;
            if (version < 2) {
                MultiKeyBindingClient.LOGGER.info("Config version outdated (found v{}, expected v{}). Upgrading...", (Object)version, (Object)2);
                json = ConfigManager.migrateConfig(json, version);
                migrated = true;
            }
            if (!json.has("bindings")) {
                return;
            }
            JsonArray keyBindingsArray = json.getAsJsonArray("bindings");
            for (JsonElement element : keyBindingsArray) {
                JsonObject keyBindingJson = element.getAsJsonObject();
                UUID id = UUID.fromString(keyBindingJson.get("id").getAsString());
                String action = keyBindingJson.get("action").getAsString();
                String translationKey = keyBindingJson.get("key").getAsString();
                MultiKeyBindingManager.addKeyBinding(action, "", translationKey, id);
            }
            if (!migrated) return;
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
                return;
            }
            catch (IOException e) {
                MultiKeyBindingClient.LOGGER.error("Failed to save migrated keybindings config", (Throwable)e);
                return;
            }
        }
        catch (IOException e) {
            MultiKeyBindingClient.LOGGER.error("Failed to load config", (Throwable)e);
            return;
        }
        finally {
            isLoading = false;
        }
    }

    private static JsonObject migrateConfig(JsonObject json, int version) {
        JsonObject newConfig = new JsonObject();
        newConfig.addProperty("config_version", (Number)2);
        JsonArray newKeyBindings = new JsonArray();
        JsonArray oldKeyBindings = json.getAsJsonArray(version == 1 ? "keyBindings" : "bindings");
        for (JsonElement element : oldKeyBindings) {
            JsonObject oldBinding = element.getAsJsonObject();
            JsonObject newBinding = new JsonObject();
            newBinding.addProperty("id", oldBinding.get("id").getAsString());
            newBinding.addProperty("action", oldBinding.get("action").getAsString());
            if (version == 1 && oldBinding.has("keyCode")) {
                int keyCode = oldBinding.get("keyCode").getAsInt();
                String keyName = ConfigManager.convertKeyCodeToKeyName(keyCode);
                newBinding.addProperty("key", keyName);
            } else {
                newBinding.addProperty("key", oldBinding.get("key").getAsString());
            }
            newKeyBindings.add((JsonElement)newBinding);
        }
        newConfig.add("bindings", (JsonElement)newKeyBindings);
        return newConfig;
    }

    private static JsonArray getFormattedKeyBindings() {
        JsonArray keyBindingsArray = new JsonArray();
        for (MultiKeyBinding multiKeyBinding : MultiKeyBindingManager.getKeyBindings()) {
            JsonObject keyBindingJson = new JsonObject();
            keyBindingJson.addProperty("id", multiKeyBinding.getId().toString());
            keyBindingJson.addProperty("action", multiKeyBinding.getAction());
            keyBindingJson.addProperty("key", multiKeyBinding.getKey().method_1441());
            keyBindingsArray.add((JsonElement)keyBindingJson);
        }
        return keyBindingsArray;
    }

    private static String convertKeyCodeToKeyName(int keyCode) {
        class_3675.class_307 keyType = keyCode <= 10 ? class_3675.class_307.field_1672 : class_3675.class_307.field_1668;
        return keyType.method_1447(keyCode).method_1441();
    }
}

