/*
 * Decompiled with CFR 0.152.
 */
package us.kenny;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_7172;
import us.kenny.ConfigManager;
import us.kenny.core.MultiKeyBinding;
import us.kenny.core.StickyMultiKeyBinding;

@Environment(value=EnvType.CLIENT)
public class MultiKeyBindingManager {
    private static class_315 gameOptions;
    private static final Map<String, List<MultiKeyBinding>> ACTION_TO_BINDINGS;
    private static final Map<class_3675.class_306, List<MultiKeyBinding>> KEY_TO_BINDINGS;
    private static final Map<UUID, MultiKeyBinding> ID_TO_BINDING;

    public static class_315 getGameOptions() {
        return gameOptions;
    }

    public static void setGameOptions(class_315 gameOptions) {
        MultiKeyBindingManager.gameOptions = gameOptions;
    }

    public static MultiKeyBinding addKeyBinding(String action, String category, String translationKey) {
        UUID newId = UUID.randomUUID();
        MultiKeyBinding multiKeyBinding = MultiKeyBindingManager.addKeyBinding("multi." + action, category, translationKey, newId);
        ConfigManager.saveConfigFile();
        return multiKeyBinding;
    }

    public static MultiKeyBinding addKeyBinding(String action, String category, String translationKey, UUID newId) {
        class_3675.class_306 key = class_3675.method_15981((String)translationKey);
        MultiKeyBinding multiKeyBinding = action.equals("multi.key.sneak") ? new StickyMultiKeyBinding(newId, action, category, key, () -> ((class_7172)gameOptions.method_42449()).method_41753()) : (action.equals("multi.key.sprint") ? new StickyMultiKeyBinding(newId, action, category, key, () -> ((class_7172)gameOptions.method_42449()).method_41753()) : new MultiKeyBinding(newId, action, category, key));
        ID_TO_BINDING.put(newId, multiKeyBinding);
        ACTION_TO_BINDINGS.computeIfAbsent(action, k -> new ArrayList()).add(multiKeyBinding);
        KEY_TO_BINDINGS.computeIfAbsent(key, k -> new ArrayList()).add(multiKeyBinding);
        return multiKeyBinding;
    }

    public static Collection<MultiKeyBinding> getKeyBindings(String action) {
        return ACTION_TO_BINDINGS.getOrDefault("multi." + action, new ArrayList());
    }

    public static Collection<MultiKeyBinding> getKeyBindings(class_3675.class_306 key) {
        return KEY_TO_BINDINGS.getOrDefault(key, new ArrayList());
    }

    public static Collection<MultiKeyBinding> getKeyBindings() {
        return ID_TO_BINDING.values();
    }

    public static void setKeyBinding(MultiKeyBinding multiKeyBinding, class_3675.class_306 newKey) {
        if (multiKeyBinding == null) {
            return;
        }
        class_3675.class_306 oldKey = multiKeyBinding.getKey();
        if (oldKey == newKey) {
            return;
        }
        multiKeyBinding.setKey(newKey);
        KEY_TO_BINDINGS.computeIfPresent(oldKey, (k, v) -> {
            v.remove(multiKeyBinding);
            return v;
        });
        KEY_TO_BINDINGS.computeIfAbsent(newKey, k -> new ArrayList()).add(multiKeyBinding);
        ConfigManager.saveConfigFile();
    }

    public static void removeKeyBinding(MultiKeyBinding multiKeyBinding) {
        if (multiKeyBinding == null) {
            return;
        }
        ID_TO_BINDING.remove(multiKeyBinding.getId());
        ACTION_TO_BINDINGS.computeIfPresent(multiKeyBinding.getAction(), (k, v) -> {
            v.remove(multiKeyBinding);
            return v;
        });
        KEY_TO_BINDINGS.computeIfPresent(multiKeyBinding.getKey(), (k, v) -> {
            v.remove(multiKeyBinding);
            return v;
        });
        ConfigManager.saveConfigFile();
    }

    static {
        ACTION_TO_BINDINGS = new HashMap<String, List<MultiKeyBinding>>();
        KEY_TO_BINDINGS = new HashMap<class_3675.class_306, List<MultiKeyBinding>>();
        ID_TO_BINDING = new HashMap<UUID, MultiKeyBinding>();
    }
}

