/*
 * Decompiled with CFR 0.152.
 */
package com.example.discordvelocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Plugin(id="discordvelocity", name="DiscordVelocity", version="1.0.0", authors={"GitHub Copilot"})
public class DiscordVelocity {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private JDA jda;
    private long channelId = 0L;
    private String token = "";
    private Map<String, Object> config = null;

    @Inject
    public DiscordVelocity(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInit(ProxyInitializeEvent event) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.logger.error("Failed to load config: ", e);
        }
        this.startBotAsync();
        CompletableFuture.runAsync(() -> {
            try {
                this.waitForJdaReady();
                this.sendConfiguredMessage("startup", null);
            }
            catch (Exception e) {
                this.logger.error("Error while sending startup message", e);
            }
        });
        this.server.getEventManager().register((Object)this, (Object)this);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.sendConfiguredMessage("shutdown", null);
        if (this.jda != null) {
            this.jda.shutdown();
        }
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent event) {
        Player player = event.getPlayer();
        this.sendConfiguredMessage("join", player);
    }

    @Subscribe
    public void onPlayerLeave(DisconnectEvent event) {
        Player player = event.getPlayer();
        this.sendConfiguredMessage("leave", player);
    }

    private void loadConfig() throws IOException {
        Object botSection;
        Path cfg;
        if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
            Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
        }
        if (!Files.exists(cfg = this.dataDirectory.resolve("config.yml"), new LinkOption[0])) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("default-config.yml");){
                if (in != null) {
                    Files.copy(in, cfg, new CopyOption[0]);
                }
            }
        }
        Yaml yaml = new Yaml();
        try (InputStream is = Files.newInputStream(cfg, new OpenOption[0]);){
            this.config = (Map)yaml.load(is);
        }
        if (this.config == null) {
            this.config = Map.of();
        }
        if ((botSection = this.config.get("bot")) instanceof Map) {
            Object cid;
            Map botmap = (Map)botSection;
            Object t = botmap.get("token");
            if (t != null) {
                this.token = String.valueOf(t);
            }
            if ((cid = botmap.get("channel_id")) != null) {
                try {
                    this.channelId = Long.parseUnsignedLong(String.valueOf(cid));
                }
                catch (NumberFormatException e) {
                    this.channelId = 0L;
                }
            }
        }
    }

    private void startBotAsync() {
        if (this.token == null || this.token.isBlank() || this.channelId == 0L) {
            this.logger.warn("Discord token or channel ID not configured; bot will not start");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.jda = JDABuilder.createDefault(this.token).build();
                this.waitForJdaReady();
                this.logger.info("Discord bot started");
            }
            catch (Exception e) {
                this.logger.error("Failed to start JDA", e);
            }
        });
    }

    private void waitForJdaReady() throws InterruptedException, ExecutionException {
        if (this.jda == null) {
            return;
        }
        this.jda.awaitReady();
    }

    private void sendConfiguredMessage(String key, Player player) {
        Object val;
        if (player != null && "Player".equals(player.getUsername())) {
            return;
        }
        String template = null;
        Object msgs = this.config.get("messages");
        if (msgs instanceof Map && (val = ((Map)msgs).get(key)) != null) {
            template = String.valueOf(val);
        }
        if (template == null || template.isBlank()) {
            return;
        }
        String msg = this.applyPlaceholders(template, player);
        this.sendMessage(msg);
    }

    private String applyPlaceholders(String template, Player player) {
        int online = this.server.getAllPlayers().size();
        String result = template.replace("{velocity_online}", String.valueOf(online));
        if (player != null) {
            result = result.replace("{player}", this.escapeUnderscores(player.getUsername()));
        }
        return result;
    }

    private String escapeUnderscores(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("_", "\\_");
    }

    private void sendMessage(String content) {
        if (this.jda == null) {
            this.logger.warn("JDA not initialized; cannot send message: {}", (Object)content);
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel == null) {
            this.logger.warn("Text channel with id {} not found or bot doesn't have access", (Object)this.channelId);
            return;
        }
        channel.sendMessage(content).queue(success -> {}, failure -> this.logger.error("Failed to send Discord message", (Throwable)failure));
    }
}

