/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.berry_good.core;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BGConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Boolean> sweetBerriesRequirePips;
        public final ModConfigSpec.ConfigValue<Boolean> glowBerriesRequirePips;
        public final ModConfigSpec.ConfigValue<Boolean> glowBerriesGiveGlowing;
        public final ModConfigSpec.ConfigValue<Boolean> foxMusicDisc;
        public final ModConfigSpec.ConfigValue<Double> foxMusicDiscChance;

        Common(ModConfigSpec.Builder builder) {
            builder.push("tweaks");
            builder.push("sweet_berries");
            this.sweetBerriesRequirePips = builder.comment("If Sweet Berry Bushes require pips to place, to prevent accidental placement").define("Sweet Berries require pips", true);
            builder.pop();
            builder.push("glow_berries");
            this.glowBerriesRequirePips = builder.comment("If Cave Vines require pips to place, to prevent accidental placement").define("Glow Berries require pips", true);
            this.glowBerriesGiveGlowing = builder.comment("If Glow Berries give Glowing upon consumption").define("Glow Berries give Glowing", true);
            builder.pop();
            builder.pop();
            builder.push("items");
            builder.push("music_disc_fox");
            this.foxMusicDisc = builder.comment("If Foxes can spawn with a Fox music disc").define("Enable Fox music disc", true);
            this.foxMusicDiscChance = builder.comment("The chance that a Fox has to spawn with a Fox music disc").define("Fox music disc chance", (Object)0.01);
            builder.pop();
            builder.pop();
        }
    }
}

