/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.berry_good.core;

import com.teamabnormals.berry_good.core.BGConfig;
import com.teamabnormals.berry_good.core.data.client.BGBlockStateProvider;
import com.teamabnormals.berry_good.core.data.client.BGItemModelProvider;
import com.teamabnormals.berry_good.core.data.client.BGLanguageProvider;
import com.teamabnormals.berry_good.core.data.client.BGSoundDefinitionsProvider;
import com.teamabnormals.berry_good.core.data.server.BGDataMapProvider;
import com.teamabnormals.berry_good.core.data.server.BGDataRemolderProvider;
import com.teamabnormals.berry_good.core.data.server.BGDatapackProvider;
import com.teamabnormals.berry_good.core.data.server.BGLootTableProvider;
import com.teamabnormals.berry_good.core.data.server.BGRecipeProvider;
import com.teamabnormals.berry_good.core.data.server.modifiers.BGAdvancementModifierProvider;
import com.teamabnormals.berry_good.core.data.server.tags.BGBlockTagsProvider;
import com.teamabnormals.berry_good.core.data.server.tags.BGItemTagsProvider;
import com.teamabnormals.berry_good.core.other.BGCompat;
import com.teamabnormals.berry_good.core.registry.BGBlocks;
import com.teamabnormals.berry_good.core.registry.BGItems;
import com.teamabnormals.berry_good.core.registry.BGSoundEvents;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="berry_good")
public class BerryGood {
    public static final String MOD_ID = "berry_good";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("berry_good");

    public BerryGood(IEventBus bus, ModContainer container) {
        BGBlocks.BLOCKS.register(bus);
        BGItems.ITEMS.register(bus);
        BGSoundEvents.SOUND_EVENTS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            BGItems.setupTabEditors();
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BGConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(BGCompat::registerCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        BGDatapackProvider datapack = new BGDatapackProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapack);
        provider = datapack.getRegistryProvider();
        BGBlockTagsProvider blockTags = new BGBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new BGItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new BGRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BGLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BGDataMapProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BGDataRemolderProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BGAdvancementModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new BGBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new BGItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new BGLanguageProvider(output));
        generator.addProvider(client, (DataProvider)new BGSoundDefinitionsProvider(output, helper));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

