/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.berry_good.core.data.client;

import com.teamabnormals.berry_good.core.registry.BGBlocks;
import com.teamabnormals.berry_good.core.registry.BGItems;
import com.teamabnormals.berry_good.core.registry.datapack.BGJukeboxSongs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.text.WordUtils;

public class BGLanguageProvider
extends LanguageProvider {
    public BGLanguageProvider(PackOutput output) {
        super(output, "berry_good", "en_us");
    }

    protected void addTranslations() {
        this.add((Block)BGBlocks.SWEET_BERRY_BASKET.get(), "Basket of Sweet Berries");
        this.add((Block)BGBlocks.GLOW_BERRY_BASKET.get(), "Basket of Glow Berries");
        this.add((Item)BGItems.SWEET_BERRY_PIPS.get(), (Item)BGItems.SWEET_BERRY_MINCE.get(), (Item)BGItems.SWEET_BERRY_MEATBALLS.get(), (Item)BGItems.GLOW_BERRY_PIPS.get(), (Item)BGItems.GLOWGURT.get());
        this.addDisc((Item)BGItems.MUSIC_DISC_FOX.get(), BGJukeboxSongs.FOX, "RENREN - Fox");
    }

    private void add(Item ... items) {
        for (Item item : items) {
            this.add(item, this.format(BuiltInRegistries.ITEM.getKey((Object)item)));
        }
    }

    private void addDisc(Item item, ResourceKey<JukeboxSong> song, String description) {
        this.add(item, "Music Disc");
        ResourceLocation key = song.location();
        this.add("jukebox_song." + key.getNamespace() + "." + key.getPath(), description);
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.getPath().replace("_", " "));
    }
}

