/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.berry_good.core.data.server.modifiers;

import com.teamabnormals.berry_good.core.registry.BGItems;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;

public class BGAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final Item[] EDIBLE_ITEMS = new Item[]{(Item)BGItems.SWEET_BERRY_MINCE.get(), (Item)BGItems.SWEET_BERRY_MEATBALLS.get(), (Item)BGItems.GLOWGURT.get()};

    public BGAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super("berry_good", output, lookupProvider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        for (Item item : EDIBLE_ITEMS) {
            balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey((Object)item).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)item));
        }
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("sweet_berry_bush", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.SWEET_BERRY_BUSH)).addCriterion("cave_vines", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.CAVE_VINES)).addIndexedRequirements(0, false, new String[]{"sweet_berry_bush", "cave_vines"}).build(), new ICondition[0]);
    }
}

