/*
 * Decompiled with CFR 0.152.
 */
package enderpearl.mamtak.enderPearlCooldown;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EnderPearlCooldown
extends JavaPlugin
implements Listener,
TabCompleter {
    private long cooldownMillis;
    private final Map<UUID, Long> lastUse = new HashMap<UUID, Long>();

    public void onEnable() {
        this.getConfig().addDefault("cooldown", (Object)"5s");
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.loadCooldown();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("enderpearl")).setExecutor((CommandExecutor)this);
        this.getCommand("enderpearl").setTabCompleter((TabCompleter)this);
        this.getLogger().info("EnderPearlCooldown enabled (cooldown=" + this.getConfig().getString("cooldown") + ")");
    }

    private void loadCooldown() {
        String raw = this.getConfig().getString("cooldown", "5s").toLowerCase();
        try {
            long val = Long.parseLong(raw.substring(0, raw.length() - 1));
            if (raw.endsWith("m")) {
                val *= 60L;
            }
            this.cooldownMillis = val * 1000L;
        }
        catch (Exception e) {
            this.getLogger().warning("Bad format in config.yml, defaulting to 5s.");
            this.cooldownMillis = 5000L;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /enderpearl <cooldown set <time|default> | time get | reload>");
            return true;
        }
        if (args[0].equalsIgnoreCase("cooldown")) {
            if (!sender.hasPermission("enderpearl.cooldown.set")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission.");
                return true;
            }
            if (args.length == 3 && args[1].equalsIgnoreCase("set")) {
                String t = args[2].toLowerCase();
                if (t.equals("default")) {
                    t = this.getConfig().getDefaults().getString("cooldown", "5s");
                } else if (!t.matches("\\d+[sm]")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Use a number plus 's' or 'm' (e.g. 5s, 2m) or 'default'.");
                    return true;
                }
                this.getConfig().set("cooldown", (Object)t);
                this.saveConfig();
                this.loadCooldown();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cooldown set to " + String.valueOf(ChatColor.AQUA) + t);
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /enderpearl cooldown set <time|default>");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("time") && args.length == 2 && args[1].equalsIgnoreCase("get")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current cooldown: " + String.valueOf(ChatColor.AQUA) + this.getConfig().getString("cooldown"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("enderpearl.cooldown.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission.");
                return true;
            }
            this.reloadConfig();
            this.loadCooldown();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded. Cooldown=" + String.valueOf(ChatColor.AQUA) + this.getConfig().getString("cooldown"));
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown sub-command.");
        return true;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand == null || hand.getType() != Material.ENDER_PEARL) {
            return;
        }
        event.setCancelled(true);
        final UUID id = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.lastUse.containsKey(id) && now - this.lastUse.get(id) < this.cooldownMillis) {
            return;
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            hand.setAmount(hand.getAmount() - 1);
            player.getInventory().setItemInMainHand(hand);
        }
        player.launchProjectile(EnderPearl.class);
        this.lastUse.put(id, now);
        int ticks = (int)(this.cooldownMillis / 50L);
        player.setCooldown(Material.ENDER_PEARL, ticks);
        new BukkitRunnable(){

            public void run() {
                EnderPearlCooldown.this.lastUse.remove(id);
            }
        }.runTaskLater((Plugin)this, (long)ticks);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("cooldown", "time", "reload").stream().filter(x -> x.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("cooldown")) {
                return Collections.singletonList("set").stream().filter(x -> x.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("time")) {
                return Collections.singletonList("get").stream().filter(x -> x.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("cooldown") && args[1].equalsIgnoreCase("set")) {
            return Arrays.asList("default", "5s", "10s", "1m", "2m").stream().filter(x -> x.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

