/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.luminous_no_shading.impl.client;

import io.github.startsmercury.luminous_no_shading.impl.client.ClearRenderType;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingRenderTypes;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingSheets;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4722;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_828;
import net.minecraft.class_829;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class LuminousNoShadingImpl {
    public static final String LUMINOUS_SUFFIX = "_luminous";
    public static final String NO_SHADING_SUFFIX = "_no_shading";
    private static boolean guiOnly;
    private static boolean onGui;
    private static ReferenceSet<class_1921> unknowns;

    public static void resetMinimalRenderTypes() {
        ClearRenderType.clear(class_829.field_4377);
        ClearRenderType.clear(class_4722.field_21723);
    }

    public static void resetRenderTypes() {
        LuminousNoShadingImpl.resetMinimalRenderTypes();
        ClearRenderType.clear(class_829.field_4378);
        ClearRenderType.clear(class_829.field_4373);
        ClearRenderType.clear(class_829.field_4371);
        ClearRenderType.clear(class_829.field_4379);
        ClearRenderType.clear(class_829.field_4380);
        ClearRenderType.clear(class_828.field_4369);
    }

    public static void applyMinimalRenderTypes() {
        class_829.field_4377.method_24146(NoShadingRenderTypes::entitySolid);
        class_4722.field_21723.method_24146(atlasLocations -> class_1921.method_23576((class_2960)LuminousNoShadingImpl.mangle(atlasLocations)));
    }

    public static void applyRenderTypes() {
        LuminousNoShadingImpl.applyMinimalRenderTypes();
        class_829.field_4378.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
        class_829.field_4373.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
        class_829.field_4371.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
        class_829.field_4379.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
        class_829.field_4380.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
        class_828.field_4369.method_24146(NoShadingRenderTypes::entitySolid);
    }

    public static boolean isGuiOnly() {
        return guiOnly;
    }

    public static void setGuiOnly(boolean guiOnly) {
        boolean wasGuiOnly = LuminousNoShadingImpl.guiOnly;
        if (wasGuiOnly == guiOnly) {
            return;
        }
        LuminousNoShadingImpl.guiOnly = guiOnly;
        LuminousNoShadingImpl.resetRenderTypes();
        if (!guiOnly) {
            LuminousNoShadingImpl.applyRenderTypes();
        }
    }

    public static boolean isOnGui() {
        return onGui;
    }

    public static void setOnGui(boolean onGui) {
        LuminousNoShadingImpl.onGui = onGui;
    }

    public static class_2960 mangle(class_2960 resourceLocation) {
        return class_2960.method_60655((String)"luminous-no-shading", (String)resourceLocation.method_12832());
    }

    public static class_1921 modifyBlockRenderType(class_1921 original, class_2680 state) {
        if (state.method_26213() <= 0) {
            return original;
        }
        if (original == class_1921.method_23583()) {
            return NoShadingRenderTypes.translucent();
        }
        if (original == class_4722.method_29382()) {
            return NoShadingSheets.translucentItemSheet();
        }
        if (original == class_4722.method_24074()) {
            return NoShadingSheets.cutoutBlockSheet();
        }
        LuminousNoShadingImpl.handleUnexpectedRenderType(original);
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void handleUnexpectedRenderType(class_1921 renderType) {
        ReferenceOpenHashSet unknowns = LuminousNoShadingImpl.unknowns;
        if (unknowns == null) {
            Class<LuminousNoShadingImpl> clazz = LuminousNoShadingImpl.class;
            // MONITORENTER : io.github.startsmercury.luminous_no_shading.impl.client.LuminousNoShadingImpl.class
            unknowns = LuminousNoShadingImpl.unknowns;
            if (unknowns == null) {
                LuminousNoShadingImpl.unknowns = unknowns = new ReferenceOpenHashSet();
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    String message = "[Luminous No Shading]: Detected unexpected render type (see logs)";
                    class_5250 component = class_2561.method_43470((String)"[Luminous No Shading]: Detected unexpected render type (see logs)").method_27694(style -> style.method_10977(class_124.field_1061));
                    player.method_7353((class_2561)component, false);
                }
            }
            // MONITOREXIT : clazz
        }
        if (!unknowns.add((Object)renderType)) return;
        Logger logger = LoggerFactory.getLogger((String)"Luminous No Shading");
        if (!logger.isWarnEnabled()) return;
        logger.atWarn().setCause((Throwable)((Object)new AssertionError((Object)"Unexpected render type"))).setMessage("[Luminous No Shading] " + String.valueOf(renderType)).log();
    }
}

