/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.luminous_no_shading.impl.client;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10151;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3544;
import net.minecraft.class_4239;
import net.minecraft.class_5913;
import org.apache.commons.io.IOUtils;

@Environment(value=EnvType.CLIENT)
public class NoShadingGlslPreprocessor
extends class_5913 {
    private static final String TARGET_SYSTEM_MOJ_IMPORT = "minecraft:light.glsl";
    private static final String TARGET_FUNCTION_NAME = "minecraft_mix_light";
    private static final String TARGET_FUNCTION_RENAME_PREFIX = "_ignored";
    private static final Pattern TARGET_FUNCTION_SIGNATURE_PATTERN;
    private static final String MACRO_REPLACING_TARGET_FUNCTION;
    private final class_2960 val$resourceLocation2;
    private final Map<class_2960, class_3298> val$map;
    private final Set<class_2960> importedLocations = new ObjectArraySet();

    public NoShadingGlslPreprocessor(class_2960 val$resourceLocation2, Map<class_2960, class_3298> val$map) {
        this.val$resourceLocation2 = val$resourceLocation2;
        this.val$map = val$map;
    }

    public String method_34233(boolean bl, String string) {
        class_2960 resourceLocation;
        try {
            resourceLocation = bl ? this.val$resourceLocation2.method_45134(string2 -> class_4239.method_34676((String)(string2 + string))) : class_2960.method_60654((String)string).method_45138("shaders/include/");
        }
        catch (class_151 var8) {
            class_10151.field_53937.error("Malformed GLSL import {}: {}", (Object)string, (Object)var8.getMessage());
            return "#error " + var8.getMessage();
        }
        if (!this.importedLocations.add(resourceLocation)) {
            return null;
        }
        try {
            String var5;
            try (BufferedReader reader = this.val$map.get(resourceLocation).method_43039();){
                var5 = IOUtils.toString((Reader)reader);
            }
            return this.modifyLightingCalculations(var5, bl, string);
        }
        catch (IOException var10) {
            class_10151.field_53937.error("Could not open GLSL import {}: {}", (Object)resourceLocation, (Object)var10.getMessage());
            return "#error " + var10.getMessage();
        }
    }

    private String modifyLightingCalculations(String source, boolean quotesUsed, String file) {
        if (quotesUsed || !file.equals(TARGET_SYSTEM_MOJ_IMPORT)) {
            return source;
        }
        Matcher matcher = TARGET_FUNCTION_SIGNATURE_PATTERN.matcher(source);
        if (!matcher.find()) {
            return source;
        }
        int correctLineNumber = class_3544.method_34238((String)source.substring(0, matcher.start()));
        String beforeTargetFunction = source.substring(0, matcher.start());
        String ignoreChangesToLineNumbering = "\n#line " + correctLineNumber + "\n";
        String returnTypeAndOriginalName = matcher.group(1);
        String afterReturnTypeAndChangedName = source.substring(matcher.end(1));
        return beforeTargetFunction + MACRO_REPLACING_TARGET_FUNCTION + ignoreChangesToLineNumbering + returnTypeAndOriginalName + TARGET_FUNCTION_RENAME_PREFIX + afterReturnTypeAndChangedName;
    }

    static {
        String returnType = "vec4";
        String[] parameterTypes = new String[]{"vec3", "vec3", "vec3", "vec4"};
        String optionalWhitespace = "\\s*";
        String requiredWhitespace = "\\s+";
        String identifier = "[a-zA-Z_][a-zA-Z0-9_]*";
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append("vec4");
        builder.append("\\s+");
        builder.append(TARGET_FUNCTION_NAME);
        builder.append(')');
        builder.append("\\(");
        int parameterCount = parameterTypes.length;
        int i = 0;
        while (true) {
            builder.append("\\s*");
            builder.append(parameterTypes[i]);
            builder.append("\\s+");
            builder.append("[a-zA-Z_][a-zA-Z0-9_]*");
            builder.append("\\s*");
            if (++i >= parameterCount) break;
            builder.append(',');
        }
        builder.append("\\)");
        TARGET_FUNCTION_SIGNATURE_PATTERN = Pattern.compile(builder.toString());
        String somehowDissociateFromSourceLineNumbering = "#line 0";
        String helperFunctionName = "minecraft_mix_light_ignored";
        MACRO_REPLACING_TARGET_FUNCTION = "\n${somehowDissociateFromSourceLineNumbering}\n#define ${TARGET_FUNCTION_NAME}(lightDir0, lightDir1, normal, color) ( \\\n    color                                                              \\\n)\n".replace("${somehowDissociateFromSourceLineNumbering}", "#line 0").replace("${TARGET_FUNCTION_NAME}", TARGET_FUNCTION_NAME).replace("${helperFunctionName}", "minecraft_mix_light_ignored");
    }
}

