package io.github.startsmercury.luminous_no_shading.impl.client;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4722;
import net.minecraft.class_828;
import net.minecraft.class_829;
import org.slf4j.LoggerFactory;

public class LuminousNoShadingImpl {
	public static final String LUMINOUS_SUFFIX = "_luminous";
	public static final String NO_SHADING_SUFFIX = "_no_shading";

	public static void resetMinimalRenderTypes() {
		ClearRenderType.clear(class_829.field_4377);
		ClearRenderType.clear(class_4722.field_21723);
	}

	public static void resetRenderTypes() {
		LuminousNoShadingImpl.resetMinimalRenderTypes();

		ClearRenderType.clear(class_829.field_4378);
		ClearRenderType.clear(class_829.field_4373);
		ClearRenderType.clear(class_829.field_4371);
		ClearRenderType.clear(class_829.field_4379);
		ClearRenderType.clear(class_829.field_4380);
		ClearRenderType.clear(class_828.field_4369);
	}

	public static void applyMinimalRenderTypes() {
		class_829.field_4377.method_24146(NoShadingRenderTypes::entitySolid);
		class_4722.field_21723.method_24146(atlasLocations -> class_1921.method_23576(
				LuminousNoShadingImpl.mangle(atlasLocations)
		));
	}

	public static void applyRenderTypes() {
		LuminousNoShadingImpl.applyMinimalRenderTypes();

		class_829.field_4378.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
		class_829.field_4373.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
		class_829.field_4371.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
		class_829.field_4379.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
		class_829.field_4380.method_24146(NoShadingRenderTypes::entityCutoutNoCull);
		class_828.field_4369.method_24146(NoShadingRenderTypes::entitySolid);
	}

	private static boolean guiOnly;

	public static boolean isGuiOnly() {
		return LuminousNoShadingImpl.guiOnly;
	}

	public static void setGuiOnly(final boolean guiOnly) {
		final var wasGuiOnly = LuminousNoShadingImpl.guiOnly;
        if (wasGuiOnly == guiOnly) {
            return;
        }

        LuminousNoShadingImpl.guiOnly = guiOnly;
        LuminousNoShadingImpl.resetRenderTypes();
        if (!guiOnly) {
            LuminousNoShadingImpl.applyRenderTypes();
        }
    }

	private static boolean onGui;

	public static boolean isOnGui() {
		return LuminousNoShadingImpl.onGui;
	}

	public static void setOnGui(final boolean onGui) {
		LuminousNoShadingImpl.onGui = onGui;
	}

	public static class_2960 mangle(final class_2960 resourceLocation) {
		return class_2960.method_60655("luminous-no-shading", resourceLocation.method_12832());
	}

	public static class_1921 modifyBlockRenderType(final class_1921 original, final class_2680 state) {
		if (state.method_26213() <= 0) {
			return original;
		} else if (original == class_1921.method_23583()) {
			return NoShadingRenderTypes.translucent();
		} else if (original == class_4722.method_29382()) {
			return NoShadingSheets.translucentItemSheet();
		} else if (original == class_4722.method_24074()) {
			return NoShadingSheets.cutoutBlockSheet();
		} else {
			handleUnexpectedRenderType(original);
			return original;
		}
	}

    private static ReferenceSet<class_1921> unknowns;

    private static void handleUnexpectedRenderType(final class_1921 renderType) {
        var unknowns = LuminousNoShadingImpl.unknowns;

        if (unknowns == null) {
            synchronized (LuminousNoShadingImpl.class) {
                unknowns = LuminousNoShadingImpl.unknowns;

                if (unknowns == null) {
                    LuminousNoShadingImpl.unknowns = unknowns = new ReferenceOpenHashSet<>();

                    final var player = class_310.method_1551().field_1724;

                    if (player != null) {
                        final var message =
                            "[Luminous No Shading]: Detected unexpected render type (see logs)";
                        final var component = class_2561.method_43470(message)
                            .method_27694(style -> style.method_10977(class_124.field_1061));
                        player.method_7353(component, false);
                    }
                }
            }
        }

        if (unknowns.add(renderType)) {
            final var logger = LoggerFactory.getLogger("Luminous No Shading");

            if (logger.isWarnEnabled()) {
                logger
                    .atWarn()
                    .setCause(new AssertionError("Unexpected render type"))
                    .setMessage("[Luminous No Shading] " + renderType)
                    .log();
            }
        }
    }
}
