package io.github.startsmercury.luminous_no_shading.impl.client;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_10151;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3544;
import net.minecraft.class_4239;
import net.minecraft.class_5913;

public class NoShadingGlslPreprocessor extends class_5913 {
    private static final String TARGET_SYSTEM_MOJ_IMPORT = "minecraft:light.glsl";

    private static final String TARGET_FUNCTION_NAME = "minecraft_mix_light";

    private static final String TARGET_FUNCTION_RENAME_PREFIX = "_ignored";

    private static final Pattern TARGET_FUNCTION_SIGNATURE_PATTERN;
    static {
        final var returnType = "vec4";
        final var parameterTypes = new String[] { "vec3", "vec3", "vec3", "vec4" };

        final var optionalWhitespace = "\\s*";
        final var requiredWhitespace = "\\s+";
        final var identifier = "[a-zA-Z_][a-zA-Z0-9_]*";

        final var builder = new StringBuilder();
        builder.append('(');
        builder.append(returnType);
        builder.append(requiredWhitespace);
        builder.append(TARGET_FUNCTION_NAME);
        builder.append(')');

        builder.append("\\(");
        final var parameterCount = parameterTypes.length;
        for (var i = 0; ; ) {
            builder.append(optionalWhitespace);
            builder.append(parameterTypes[i]);
            builder.append(requiredWhitespace);
            builder.append(identifier);
            builder.append(optionalWhitespace);
            if (++i >= parameterCount) {
                break;
            }
            builder.append(',');
        }
        builder.append("\\)");

        TARGET_FUNCTION_SIGNATURE_PATTERN = Pattern.compile(builder.toString());
    }

    private static final String MACRO_REPLACING_TARGET_FUNCTION;
    static {
        final var somehowDissociateFromSourceLineNumbering = "#line 0";
        final var helperFunctionName = TARGET_FUNCTION_NAME + TARGET_FUNCTION_RENAME_PREFIX;

        MACRO_REPLACING_TARGET_FUNCTION = """
            
            ${somehowDissociateFromSourceLineNumbering}
            #define ${TARGET_FUNCTION_NAME}(lightDir0, lightDir1, normal, color) ( \\
                color                                                              \\
            )
            """
            .replace("${somehowDissociateFromSourceLineNumbering}", somehowDissociateFromSourceLineNumbering)
            .replace("${TARGET_FUNCTION_NAME}", TARGET_FUNCTION_NAME)
            .replace("${helperFunctionName}", helperFunctionName);
    }

    private final class_2960 val$resourceLocation2;

    private final Map<class_2960, class_3298> val$map;

    private final Set<class_2960> importedLocations = new ObjectArraySet<>();

    public NoShadingGlslPreprocessor(
        final class_2960 val$resourceLocation2,
        final Map<class_2960, class_3298> val$map
    ) {
        this.val$resourceLocation2 = val$resourceLocation2;
        this.val$map = val$map;
    }

    @Override
    public String method_34233(boolean bl, String string) {
        class_2960 resourceLocation;
        try {
            if (bl) {
                resourceLocation = val$resourceLocation2.method_45134(
                    string2 -> class_4239.method_34676(string2 + string)
                );
            } else {
                resourceLocation = class_2960.method_60654(string)
                    .method_45138("shaders/include/");
            }
        } catch (class_151 var8) {
            class_10151.field_53937.error(
                "Malformed GLSL import {}: {}",
                string,
                var8.getMessage()
            );
            return "#error " + var8.getMessage();
        }

        if (!this.importedLocations.add(resourceLocation)) {
            return null;
        } else {
            try {
                Reader reader = val$map.get(resourceLocation).method_43039();

                String var5;
                try {
                    var5 = IOUtils.toString(reader);
                } catch (Throwable var9) {
                    try {
                        reader.close();
                    } catch (Throwable var7) {
                        var9.addSuppressed(var7);
                    }

                    throw var9;
                }

                reader.close();

                return modifyLightingCalculations(var5, bl, string);
            } catch (IOException var10) {
                class_10151.field_53937.error(
                    "Could not open GLSL import {}: {}",
                    resourceLocation,
                    var10.getMessage()
                );
                return "#error " + var10.getMessage();
            }
        }
    }

    private String modifyLightingCalculations(
        final String source,
        final boolean quotesUsed,
        final String file
    ) {
        if (quotesUsed || !file.equals(TARGET_SYSTEM_MOJ_IMPORT)) {
            return source;
        }

        final var matcher = TARGET_FUNCTION_SIGNATURE_PATTERN.matcher(source);
        if (!matcher.find()) {
            return source;
        }

        final var correctLineNumber =
            class_3544.method_34238(source.substring(0, matcher.start()));

        final var beforeTargetFunction = source.substring(0, matcher.start());
        final var ignoreChangesToLineNumbering = "\n#line " + correctLineNumber + "\n";
        final var returnTypeAndOriginalName = matcher.group(1);
        final var afterReturnTypeAndChangedName = source.substring(matcher.end(1));

        return beforeTargetFunction
            + MACRO_REPLACING_TARGET_FUNCTION
            + ignoreChangesToLineNumbering
            + returnTypeAndOriginalName
            + TARGET_FUNCTION_RENAME_PREFIX
            + afterReturnTypeAndChangedName;
    }
}
