package io.github.startsmercury.luminous_no_shading.impl.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.function.Consumer;
import net.minecraft.class_10785;

public final class NoShadingRenderPipelines {
    /**
     * In the creation of a custom derived {@link class_10785}, its builder
     * is reused.
     */
    public static final String M_BUILD = """
        Lcom/mojang/blaze3d/pipeline/RenderPipeline$Builder; \
        build (                                              \
        ) Lcom/mojang/blaze3d/pipeline/RenderPipeline;       \
    """;

    /**
     * A custom {@link class_10785} is registered after its original.
     */
    public static final String M_REGISTER = """
        Lnet/minecraft/client/renderer/RenderPipelines;  \
        register (                                       \
            Lcom/mojang/blaze3d/pipeline/RenderPipeline; \
        ) Lcom/mojang/blaze3d/pipeline/RenderPipeline;   \
    """;

    public static class_10785 TRANSLUCENT;
    public static class_10785 ENTITY_SOLID;
    public static class_10785 ENTITY_CUTOUT;
    public static class_10785 ENTITY_CUTOUT_NO_CULL;
    public static class_10785 ITEM_ENTITY_TRANSLUCENT_CULL;

    public static class_10785 createNoShading(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original,
        final Consumer<? super class_10785> setter
    ) {
        final var pipeline = original.call(builder);

        final var customLocation = pipeline
            .method_67732()
            .method_45134(path -> path + LuminousNoShadingImpl.LUMINOUS_SUFFIX);
        final var customVertexShader = pipeline
            .method_67736()
            .method_45134(path -> path + LuminousNoShadingImpl.NO_SHADING_SUFFIX);
        final var customPipeline = builder
            .method_67742(customLocation)
            .method_67761(customVertexShader)
            .method_67760();
        setter.accept(customPipeline);

        return pipeline;
    }

    public static class_10785 createLuminous(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original,
        final Consumer<? super class_10785> setter
    ) {
        final var pipeline = original.call(builder);

        final var customLocation = pipeline
            .method_67732()
            .method_45134(path -> path + LuminousNoShadingImpl.LUMINOUS_SUFFIX);
        final var customPipeline = builder
            .method_67742(customLocation)
            .method_67764("NO_CARDINAL_LIGHTING")
            .method_67760();
        setter.accept(customPipeline);

        return pipeline;
    }

    public static void t(final class_10785 translucent) {
        TRANSLUCENT = translucent;
    }

    public static void es(final class_10785 entitySolid) {
        ENTITY_SOLID = entitySolid;
    }

    public static void ec(final class_10785 entityCutout) {
        ENTITY_CUTOUT = entityCutout;
    }

    public static void ecnc(final class_10785 entityCutoutNoCull) {
        ENTITY_CUTOUT_NO_CULL = entityCutoutNoCull;
    }

    public static void ietc(final class_10785 itemEntityTranslucentCell) {
        ITEM_ENTITY_TRANSLUCENT_CULL = itemEntityTranslucentCell;
    }
}
