package io.github.startsmercury.luminous_no_shading.mixin.client.shader.minecraft;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingRenderPipelines;
import net.minecraft.class_10785;
import net.minecraft.class_10799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static io.github.startsmercury.luminous_no_shading.impl.client.NoShadingRenderPipelines.*;

@Mixin(class_10799.class)
public abstract class RenderPipelinesMixin {
    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", target = M_BUILD, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/entity_solid"
        ))
    )
    private static class_10785 createCustomEntitySolid(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original
    ) {
        return createLuminous(builder, original, NoShadingRenderPipelines::es);
    }

    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", target = M_BUILD, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/translucent"
        ))
    )
    private static class_10785 createCustomTranslucent(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original
    ) {
        return createNoShading(builder, original, NoShadingRenderPipelines::t);
    }

    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", target = M_BUILD, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/entity_cutout"
        ))
    )
    private static class_10785 createCustomEntityCutout(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original
    ) {
        return createLuminous(builder, original, NoShadingRenderPipelines::ec);
    }

    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", target = M_BUILD, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/item_entity_translucent_cull"
        ))
    )
    private static class_10785 createCustomItemEntityTranslucentCull(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original
    ) {
        return createNoShading(builder, original, NoShadingRenderPipelines::ietc);
    }

    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", target = M_BUILD, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/entity_cutout_no_cull"
        ))
    )
    private static class_10785 createCustomEntityCutoutNoCull(
        final class_10785.class_10786 builder,
        final Operation<class_10785> original
    ) {
        return createLuminous(builder, original, NoShadingRenderPipelines::ecnc);
    }

    @Shadow
    private static class_10785 register(class_10785 renderPipeline) {
        throw new AssertionError();
    }

    @Inject(
        method = "<clinit>",
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, target = M_REGISTER, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/entity_solid"
        ))
    )
    private static void registerCustomEntitySolid(final CallbackInfo callback) {
        NoShadingRenderPipelines.ENTITY_SOLID =
            register(NoShadingRenderPipelines.ENTITY_SOLID);
    }

    @Inject(
        method = "<clinit>",
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, target = M_REGISTER, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/translucent"
        ))
    )
    private static void registerCustomTranslucent(final CallbackInfo callback) {
        NoShadingRenderPipelines.TRANSLUCENT =
            register(NoShadingRenderPipelines.TRANSLUCENT);
    }

    @Inject(
        method = "<clinit>",
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, target = M_REGISTER, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/entity_cutout"
        ))
    )
    private static void registerCustomEntityCutout(final CallbackInfo callback) {
        NoShadingRenderPipelines.ENTITY_CUTOUT =
            register(NoShadingRenderPipelines.ENTITY_CUTOUT);
    }

    @Inject(
        method = "<clinit>",
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, target = M_REGISTER, ordinal = 0),
        slice = @Slice(from = @At(
            value = "CONSTANT",
            args = "stringValue=pipeline/item_entity_translucent_cull"
        ))
    )
    private static void registerCustomItemEntityTranslucentCull(final CallbackInfo callback) {
        NoShadingRenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL =
            register(NoShadingRenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL);
    }
}
