package io.github.startsmercury.luminous_no_shading.mixin.client.shader.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.startsmercury.luminous_no_shading.impl.client.LuminousNoShadingImpl;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingRenderPipelines;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingRenderTypes;
import net.minecraft.class_10785;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1921.class)
public abstract class RenderTypeMixin {
    @WrapOperation(
        method = "<clinit>",
        at = @At(value = "INVOKE", ordinal = 0, target = "Lnet/minecraft/client/renderer/RenderType;create(Ljava/lang/String;ILcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/client/renderer/RenderType$CompositeState;)Lnet/minecraft/client/renderer/RenderType$CompositeRenderType;"),
        slice = @Slice(from = @At(value = "CONSTANT", ordinal = 0, args = "stringValue=translucent"))
    )
    private static class_1921.class_4687 createCustomTranslucent(
        final String name,
        final int bufferSize,
        final class_10785 renderPipeline,
        final class_1921.class_4688 state,
        final Operation<class_1921.class_4687> original
    ) {
        final var result = original.call(name, bufferSize, renderPipeline, state);
        NoShadingRenderTypes.TRANSLUCENT = original.call(name + LuminousNoShadingImpl.LUMINOUS_SUFFIX, bufferSize, NoShadingRenderPipelines.TRANSLUCENT, state);
        return result;
    }

    @Inject(
        method = { "method_34832", "method_34826", "method_62288", "method_34824" },
        at = @At("HEAD")
    )
    private static void detectCustom(
        final CallbackInfoReturnable<class_1921> callback,
        final @Local(ordinal = 0, argsOnly = true) LocalRef<class_2960> resourceLocationRef,
        final @Share("custom") LocalBooleanRef custom
    ) {
        final var resourceLocation = resourceLocationRef.get();
        if ("luminous-no-shading".equals(resourceLocation.method_12836())) {
            resourceLocationRef.set(
                class_2960.method_60656(resourceLocation.method_12832())
            );
            custom.set(true);
        }
    }

    @ModifyExpressionValue(
        method = "method_34832",
        at = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/RenderPipelines;ENTITY_CUTOUT_NO_CULL:Lcom/mojang/blaze3d/pipeline/RenderPipeline;")
    )
    private static class_10785 createCustomEntityCutoutNoCullProvider(
        final class_10785 original,
        final @Share("custom") LocalBooleanRef custom
    ) {
        if (custom.get()) {
            return NoShadingRenderPipelines.ENTITY_CUTOUT_NO_CULL;
        } else {
            return original;
        }
    }

    @ModifyExpressionValue(
        method = "method_34826",
        at = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/RenderPipelines;ENTITY_SOLID:Lcom/mojang/blaze3d/pipeline/RenderPipeline;")
    )
    private static class_10785 createCustomEntitySolidProvider(
        final class_10785 original,
        final @Share("custom") LocalBooleanRef custom
    ) {
        if (custom.get()) {
            return NoShadingRenderPipelines.ENTITY_SOLID;
        } else {
            return original;
        }
    }

    @ModifyExpressionValue(
        method = "method_62288",
        at = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/RenderPipelines;ENTITY_CUTOUT:Lcom/mojang/blaze3d/pipeline/RenderPipeline;")
    )
    private static class_10785 createCustomEntityCutoutProvider(
        final class_10785 original,
        final @Share("custom") LocalBooleanRef custom
    ) {
        if (custom.get()) {
            return NoShadingRenderPipelines.ENTITY_CUTOUT;
        } else {
            return original;
        }
    }

    @ModifyExpressionValue(
        method = "method_34824",
        at = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/RenderPipelines;ITEM_ENTITY_TRANSLUCENT_CULL:Lcom/mojang/blaze3d/pipeline/RenderPipeline;")
    )
    private static class_10785 createCustomItemEntityTranslucentCullProvider(
        final class_10785 original,
        final @Share("custom") LocalBooleanRef custom
    ) {
        if (custom.get()) {
            return NoShadingRenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL;
        } else {
            return original;
        }
    }
}
