package io.github.startsmercury.luminous_no_shading.mixin.client.shader.minecraft;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.startsmercury.luminous_no_shading.impl.client.LuminousNoShadingImpl;
import io.github.startsmercury.luminous_no_shading.impl.client.NoShadingGlslPreprocessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_10151;
import net.minecraft.class_282;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_4239;

@Mixin(class_10151.class)
public abstract class ShaderManagerMixin {
    @Inject(
        method = """
            loadShader (                                         \
                Lnet/minecraft/resources/ResourceLocation;       \
                Lnet/minecraft/server/packs/resources/Resource;  \
                Lcom/mojang/blaze3d/shaders/ShaderType;          \
                Ljava/util/Map;                                  \
                Lcom/google/common/collect/ImmutableMap$Builder; \
            ) V                                                  \
        """,
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, remap = false, target = """
            Lcom/google/common/collect/ImmutableMap$Builder;   \
            put (                                              \
                Ljava/lang/Object;                             \
                Ljava/lang/Object;                             \
            ) Lcom/google/common/collect/ImmutableMap$Builder; \
        """)
    )
    private static void loadCustomShader(
        final CallbackInfo callback,
        final @Local(ordinal = 0, argsOnly = true) class_2960 resourceLocation,
        final @Local(ordinal = 0, argsOnly = true) class_282 type,
        final @Local(ordinal = 0, argsOnly = true) Map<class_2960, class_3298> map,
        final @Local(ordinal = 0, argsOnly = true) ImmutableMap.Builder<
            class_10151.class_10155,
            String
        > builder,
        final @Local(ordinal = 1) class_2960 resourceLocation2,
        final @Local(ordinal = 0) String string
    ) {
        switch (resourceLocation.method_12832()) {
            case "shaders/core/rendertype_item_entity_translucent_cull.vsh",
                 "shaders/core/terrain.vsh":
                break;
            default:
                return;
        }

        final var glslPreprocessor = new NoShadingGlslPreprocessor(
            resourceLocation.method_45134(class_4239::method_34675),
            map
        );

        builder.put(
            new class_10151.class_10155(
                resourceLocation2.method_45134(
                    path -> path + LuminousNoShadingImpl.NO_SHADING_SUFFIX
                ),
                type
            ),
            String.join("", glslPreprocessor.method_34229(string))
        );
    }

    @WrapOperation(
        method = "loadPostChain",
        at = @At(
            value = "INVOKE",
            target = """
                Lcom/google/common/collect/ImmutableMap$Builder;   \
                put (                                              \
                    Ljava/lang/Object;                             \
                    Ljava/lang/Object;                             \
                ) Lcom/google/common/collect/ImmutableMap$Builder; \
            """,
            remap = false
        )
    )
    private static <K, V> ImmutableMap.Builder<K, V> loadCustomProgram(
        ImmutableMap.Builder instance,
        final K key,
        final V value,
        final Operation<ImmutableMap.Builder<K, V>> original,
        final @Local(ordinal = 0, argsOnly = true) class_2960 resourceLocation,
        final @Local(ordinal = 1) class_2960 resourceLocation2
    ) {
        instance = original.call(instance, key, value);

        switch (resourceLocation.method_12832()) {
            case "post_effect/entity_cutout.json",
                 "post_effect/entity_cutout_no_cull.json",
                 "post_effect/entity_solid.json":
                break;
            default:
                return null;
        }

        final var resourceLocation3 = resourceLocation2.method_45134(
            path -> path + LuminousNoShadingImpl.LUMINOUS_SUFFIX
        );

        return instance.put(resourceLocation3, value);
    }
}
