/*
 * Decompiled with CFR 0.152.
 */
package com.glyceryl6.firework.crafting;

import com.glyceryl6.firework.registry.ModItems;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractCFRRecipe
extends CustomRecipe {
    public AbstractCFRRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ArrayList<ItemStack> fireworkInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> otherInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> fortifierInput = new ArrayList<ItemStack>();
        for (int j = 0; j < container.m_6643_(); ++j) {
            ItemStack slotStack = container.m_8020_(j);
            if (slotStack.m_41720_() instanceof FireworkRocketItem) {
                fireworkInput.add(slotStack);
            }
            if (slotStack.m_150930_(this.getBomletItem())) {
                otherInput.add(slotStack);
            }
            if (!slotStack.m_150930_(this.getFortifier())) continue;
            fortifierInput.add(slotStack);
        }
        return fireworkInput.size() == 1 && (otherInput.size() > 0 || fortifierInput.size() > 0);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        Item item = (Item)ModItems.CLUSTER_FIREWORK_ROCKET.get();
        ItemStack itemStack = item.m_7968_();
        ItemStack tempStack = item.m_7968_();
        ArrayList<ItemStack> otherInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> fortifierInput = new ArrayList<ItemStack>();
        for (int j = 0; j < container.m_6643_(); ++j) {
            ItemStack slotStack = container.m_8020_(j);
            if (slotStack.m_150930_(Items.f_42688_) || slotStack.m_150930_(item)) {
                tempStack = slotStack.m_41777_();
            }
            if (slotStack.m_150930_(this.getBomletItem())) {
                otherInput.add(slotStack);
            }
            if (!slotStack.m_150930_(this.getFortifier())) continue;
            fortifierInput.add(slotStack);
        }
        CompoundTag compoundTag1 = itemStack.m_41698_("Fireworks");
        CompoundTag compoundTag2 = tempStack.m_41698_("Fireworks");
        compoundTag1.m_128405_("BombletCount", compoundTag2.m_128451_("BombletCount") + otherInput.size());
        compoundTag1.m_128405_("EnhancementLevel", compoundTag2.m_128451_("EnhancementLevel") + fortifierInput.size());
        compoundTag1.m_128359_("BombletType", this.getBomletType());
        String bombletType = compoundTag2.m_128461_("BombletType");
        ListTag enchantmentTags = tempStack.m_41785_();
        for (int i = 0; i < enchantmentTags.size(); ++i) {
            CompoundTag compoundTag = enchantmentTags.m_128728_(i);
            ResourceLocation id = new ResourceLocation(compoundTag.m_128461_("id"));
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
            if (enchantment == null) continue;
            itemStack.m_41663_(enchantment, (int)compoundTag.m_128448_("lvl"));
        }
        boolean flag = tempStack.m_150930_(Items.f_42688_) || tempStack.m_150930_(item) && (bombletType.equals(this.getBomletType()) || bombletType.equals("Empty"));
        return (otherInput.size() > 0 || fortifierInput.size() > 0) && flag ? itemStack : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    protected abstract Item getBomletItem();

    protected abstract Item getFortifier();

    protected abstract String getBomletType();
}

