/*
 * Decompiled with CFR 0.152.
 */
package com.glyceryl6.firework.entities;

import com.glyceryl6.firework.registry.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BombletEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<String> BOMBLET_TYPE = SynchedEntityData.m_135353_(BombletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public int enhancementLevel;

    public BombletEntity(EntityType<? extends BombletEntity> type, Level level) {
        super(type, level);
    }

    public BombletEntity(double x, double y, double z, Level level) {
        super((EntityType)ModEntityTypes.BOMBLET.get(), x, y, z, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOMBLET_TYPE, (Object)"Empty");
    }

    protected Item m_7881_() {
        return Items.f_41996_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.getBombletType().equals("Exploding")) {
                this.makeTrail((ParticleOptions)ParticleTypes.f_123755_);
            }
            if (this.getBombletType().equals("Burning")) {
                for (int i = 0; i < 3; ++i) {
                    this.makeTrail((ParticleOptions)ParticleTypes.f_123744_);
                }
            }
        }
    }

    private void makeTrail(ParticleOptions particle) {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_9236_().m_7106_(particle, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public String getBombletType() {
        return (String)this.f_19804_.m_135370_(BOMBLET_TYPE);
    }

    public void setBombletType(String bombletType) {
        this.f_19804_.m_135381_(BOMBLET_TYPE, (Object)bombletType);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("BombletType", this.getBombletType());
        compound.m_128405_("EnhancementLevel", this.enhancementLevel);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBombletType(compound.m_128461_("BombletType"));
        this.enhancementLevel = compound.m_128451_("EnhancementLevel");
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            if (this.getBombletType().equals("Exploding")) {
                float radius = 1.5f + (float)this.enhancementLevel * 0.15f;
                level.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), radius, Level.ExplosionInteraction.TNT);
            }
            if (this.getBombletType().equals("Burning")) {
                if (result instanceof BlockHitResult) {
                    BlockHitResult hitResult = (BlockHitResult)result;
                    BlockPos pos = hitResult.m_82425_().m_121945_(hitResult.m_82434_());
                    if (level.m_46859_(pos)) {
                        level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                    }
                } else if (result instanceof EntityHitResult) {
                    EntityHitResult hitResult = (EntityHitResult)result;
                    Entity entity = hitResult.m_82443_();
                    entity.m_20254_(5 + this.enhancementLevel);
                    entity.m_6469_(this.m_269291_().m_269387_(), 5.0f);
                    Entity entity2 = this.m_19749_();
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        this.m_19970_(livingEntity, entity);
                    }
                }
            }
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        return 0.07f;
    }
}

