/*
 * Decompiled with CFR 0.152.
 */
package com.glyceryl6.firework.entities;

import com.glyceryl6.firework.entities.BombletEntity;
import com.glyceryl6.firework.registry.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ClusterFireworkRocketEntity
extends FireworkRocketEntity {
    public int bombletCount;
    public int enhancementLevel;
    public String bombletType = "Empty";

    public ClusterFireworkRocketEntity(EntityType<? extends ClusterFireworkRocketEntity> type, Level level) {
        super(type, level);
    }

    public ClusterFireworkRocketEntity(Level level, @Nullable Entity shooter, double x, double y, double z, ItemStack stack) {
        super(level, shooter, x, y, z, stack);
    }

    public ClusterFireworkRocketEntity(Level level, ItemStack stack, LivingEntity shooter) {
        super(level, stack, shooter);
    }

    public ClusterFireworkRocketEntity(Level level, ItemStack stack, double x, double y, double z) {
        super(level, stack, x, y, z, Boolean.TRUE.booleanValue());
    }

    public ClusterFireworkRocketEntity(Level level, ItemStack stack, Entity shooter, double y) {
        super(level, stack, shooter, shooter.m_20185_(), y, shooter.m_20189_(), Boolean.TRUE.booleanValue());
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntityTypes.CLUSTER_FIREWORK_ROCKET.get();
    }

    public void m_37080_() {
        Level level = this.m_9236_();
        if (this.bombletCount > 0 && !level.f_46443_) {
            for (int i = 0; i < this.bombletCount; ++i) {
                if (this.bombletType.equals("Arrow")) {
                    Arrow arrow = new Arrow(level, this.m_20208_(2.0), this.m_20187_(), this.m_20262_(2.0));
                    if (this.m_7846_().getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                        arrow.m_20254_(100);
                    }
                    arrow.m_36781_(arrow.m_36789_() + (double)((float)this.enhancementLevel * 0.5f));
                    arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    arrow.m_5602_((Entity)this);
                    level.m_7967_((Entity)arrow);
                    continue;
                }
                BombletEntity bomblet = new BombletEntity(this.m_20208_(2.0), this.m_20187_(), this.m_20262_(2.0), level);
                bomblet.m_37446_(Items.f_41996_.m_7968_());
                bomblet.setBombletType(this.bombletType);
                bomblet.enhancementLevel = this.enhancementLevel;
                level.m_7967_((Entity)bomblet);
            }
            level.m_254849_((Entity)this, this.m_20185_(), this.m_20186_() + (double)0.4f, this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
            level.m_254849_((Entity)this, this.m_20185_(), this.m_20186_() + (double)0.4f, this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
        }
        super.m_37080_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BombletCount", this.bombletCount);
        compound.m_128405_("EnhancementLevel", this.enhancementLevel);
        compound.m_128359_("BombletType", this.bombletType);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.bombletCount = compound.m_128451_("BombletCount");
        this.enhancementLevel = compound.m_128451_("EnhancementLevel");
        this.bombletType = compound.m_128461_("BombletType");
    }
}

