/*
 * Decompiled with CFR 0.152.
 */
package com.glyceryl6.firework.items;

import com.glyceryl6.firework.entities.ClusterFireworkRocketEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClusterFireworkRocketItem
extends FireworkRocketItem {
    public ClusterFireworkRocketItem() {
        super(new Item.Properties());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            Vec3 vec3 = context.m_43720_();
            ItemStack itemInHand = context.m_43722_();
            Direction direction = context.m_43719_();
            double x = vec3.f_82479_ + (double)direction.m_122429_() * 0.15;
            double y = vec3.f_82480_ + (double)direction.m_122430_() * 0.15;
            double z = vec3.f_82481_ + (double)direction.m_122431_() * 0.15;
            ClusterFireworkRocketEntity entity = new ClusterFireworkRocketEntity(level, (Entity)context.m_43723_(), x, y, z, itemInHand);
            ClusterFireworkRocketItem.spawnFireworkRocket(itemInHand, entity, level);
            itemInHand.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (player.m_21255_()) {
            if (!level.f_46443_) {
                ClusterFireworkRocketEntity entity = new ClusterFireworkRocketEntity(level, itemInHand, (LivingEntity)player);
                ClusterFireworkRocketItem.spawnFireworkRocket(itemInHand, entity, level);
                if (!player.m_150110_().f_35937_) {
                    itemInHand.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemInHand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag compoundTag = stack.m_41737_("Fireworks");
        if (compoundTag != null) {
            ListTag listTag;
            if (compoundTag.m_128425_("BombletCount", 99)) {
                tooltip.add((Component)Component.m_237115_((String)"item.cfr.cluster_firework_rocket.bomblet_count").m_130946_(String.valueOf(compoundTag.m_128451_("BombletCount") * 3)).m_130940_(ChatFormatting.GRAY));
            }
            String bombletTypeKey = "item.cfr.cluster_firework_rocket.bomblet_type";
            String bomletType = compoundTag.m_128461_("BombletType").toLowerCase(Locale.ROOT);
            MutableComponent component = Component.m_237115_((String)(bombletTypeKey + "." + bomletType));
            tooltip.add((Component)Component.m_237115_((String)bombletTypeKey).m_7220_((Component)component).m_130940_(ChatFormatting.GRAY));
            if (compoundTag.m_128425_("EnhancementLevel", 99)) {
                tooltip.add((Component)Component.m_237115_((String)"item.cfr.cluster_firework_rocket.enhancement_level").m_130946_(String.valueOf(compoundTag.m_128451_("EnhancementLevel"))).m_130940_(ChatFormatting.GRAY));
            }
            if (compoundTag.m_128425_("Flight", 99)) {
                tooltip.add((Component)Component.m_237115_((String)"item.minecraft.firework_rocket.flight").m_7220_(CommonComponents.f_263701_).m_130946_(String.valueOf(compoundTag.m_128445_("Flight"))).m_130940_(ChatFormatting.GRAY));
            }
            if (!(listTag = compoundTag.m_128437_("Explosions", 10)).isEmpty()) {
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag listTagCompound = listTag.m_128728_(i);
                    ArrayList list = Lists.newArrayList();
                    FireworkStarItem.m_41256_((CompoundTag)listTagCompound, (List)list);
                    if (list.isEmpty()) continue;
                    for (int j = 1; j < list.size(); ++j) {
                        list.set(j, Component.m_237113_((String)"  ").m_7220_((Component)list.get(j)).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.addAll(list);
                }
            }
        }
    }

    public static void spawnFireworkRocket(ItemStack stack, ClusterFireworkRocketEntity fireworkRocketEntity, Level level) {
        CompoundTag element = stack.m_41698_("Fireworks");
        fireworkRocketEntity.bombletCount = element.m_128451_("BombletCount") * 3;
        fireworkRocketEntity.enhancementLevel = element.m_128451_("EnhancementLevel");
        fireworkRocketEntity.bombletType = element.m_128461_("BombletType");
        level.m_7967_((Entity)fireworkRocketEntity);
    }

    public static class Shoot
    extends DefaultDispenseItemBehavior {
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ClusterFireworkRocketEntity entity = new ClusterFireworkRocketEntity((Level)source.m_7727_(), stack, source.m_7096_(), source.m_7098_(), source.m_7094_());
            DispenseItemBehavior.m_123395_((BlockSource)source, (Entity)entity, (Direction)direction);
            entity.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), 0.5f, 1.0f);
            ClusterFireworkRocketItem.spawnFireworkRocket(stack, entity, (Level)source.m_7727_());
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1004, source.m_7961_(), 0);
        }
    }
}

