/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.client.gui;

import net.biomeplus.init.BiomePlusModScreens;
import net.biomeplus.procedures.UmanGUIModelProcedure;
import net.biomeplus.world.inventory.UmanGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class UmanGUIScreen
extends AbstractContainerScreen<UmanGUIMenu>
implements BiomePlusModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"biome_plus:textures/screens/uman_gui.png");

    public UmanGUIScreen(UmanGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = UmanGUIModelProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)guiGraphics, (int)(this.leftPos + -876), (int)(this.topPos + -928), (int)(this.leftPos + 1124), (int)(this.topPos + 1072), (int)30, (float)(-livingEntity.getBbHeight() / (2.0f * livingEntity.getScale())), (float)(0.0f + (float)Math.atan((double)(this.leftPos + 124 - mouseX) / 40.0)), (float)((float)Math.atan((double)(this.topPos + 23 - mouseY) / 40.0)), (LivingEntity)livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/boots.png"), this.leftPos + 151, this.topPos + 62, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/helmet.png"), this.leftPos + 151, this.topPos + 8, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/leggins.png"), this.leftPos + 151, this.topPos + 44, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/chestplate.png"), this.leftPos + 151, this.topPos + 26, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/sword.png"), this.leftPos + 88, this.topPos + 53, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"biome_plus:textures/screens/shield.png"), this.leftPos + 88, this.topPos + 17, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
    }
}

