/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelFawn<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"model_fawn"), "main");
    public final ModelPart fawn;
    public final ModelPart arts;
    public final ModelPart right_front_leg;
    public final ModelPart left_front_leg;
    public final ModelPart right_rear_leg;
    public final ModelPart left_rear_leg;
    public final ModelPart Body;
    public final ModelPart tail;
    public final ModelPart Head;
    public final ModelPart Head2;

    public ModelFawn(ModelPart root) {
        this.fawn = root.getChild("fawn");
        this.arts = this.fawn.getChild("arts");
        this.right_front_leg = this.arts.getChild("right_front_leg");
        this.left_front_leg = this.arts.getChild("left_front_leg");
        this.right_rear_leg = this.arts.getChild("right_rear_leg");
        this.left_rear_leg = this.arts.getChild("left_rear_leg");
        this.Body = this.fawn.getChild("Body");
        this.tail = this.Body.getChild("tail");
        this.Head = this.fawn.getChild("Head");
        this.Head2 = this.Head.getChild("Head2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition fawn = partdefinition.addOrReplaceChild("fawn", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition arts = fawn.addOrReplaceChild("arts", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = arts.addOrReplaceChild("right_front_leg", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-12.0f, (float)5.5f));
        PartDefinition cube_r1 = right_front_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 44).addBox(-1.0f, -8.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)7.0f, (float)0.25f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = right_front_leg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(50, 10).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.25f, (float)12.0f, (float)0.5f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = arts.addOrReplaceChild("left_front_leg", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-12.0f, (float)5.5f));
        PartDefinition cube_r3 = left_front_leg.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(46, 0).addBox(-2.0f, -8.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.75f, (float)7.0f, (float)0.25f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = left_front_leg.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(50, 19).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)12.0f, (float)0.5f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition right_rear_leg = arts.addOrReplaceChild("right_rear_leg", CubeListBuilder.create().texOffs(20, 54).addBox(-1.25f, 7.0f, -2.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)-4.5f));
        PartDefinition cube_r5 = right_rear_leg.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(34, 0).addBox(1.0f, -7.0f, -2.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.25f, (float)5.25f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = right_rear_leg.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(42, 43).addBox(-1.0f, -8.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)9.25f, (float)-0.75f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_rear_leg = arts.addOrReplaceChild("left_rear_leg", CubeListBuilder.create().texOffs(12, 54).addBox(-0.75f, 7.0f, -2.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)-4.5f));
        PartDefinition cube_r7 = left_rear_leg.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(30, 43).addBox(-2.0f, -7.0f, -2.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.25f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = left_rear_leg.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 44).addBox(-2.0f, -8.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.75f, (float)9.25f, (float)-0.75f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition Body = fawn.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -18.0f, 0.5f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = Body.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -7.0f, -7.0f, 9.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-11.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = Body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-16.0f, (float)-6.5f));
        PartDefinition cube_r10 = tail.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(32, 23).addBox(-1.0f, -2.0f, -4.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.25f, (float)1.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition Head = fawn.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-16.0f, (float)6.5f));
        PartDefinition cube_r11 = Head.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(30, 30).addBox(-3.0f, -5.0f, -1.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.75f, (float)2.5f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition Head2 = Head.addOrReplaceChild("Head2", CubeListBuilder.create().texOffs(1, 30).addBox(-3.5f, -6.0f, -1.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)4.0f));
        PartDefinition cube_r12 = Head2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(1, 3).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.75f, (float)-5.75f, (float)0.75f, (float)0.4674f, (float)0.6209f, (float)0.8322f));
        PartDefinition cube_r13 = Head2.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(27, 3).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.75f, (float)-5.5f, (float)0.75f, (float)0.3663f, (float)-0.5553f, (float)-0.6291f));
        PartDefinition cube_r14 = Head2.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(32, 15).addBox(-3.0f, -3.0f, -4.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.25f, (float)6.5f, (float)-0.48f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.fawn.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.right_front_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.right_rear_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.left_rear_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_front_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

