/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.biomeplus.client.model.Modelcrab;
import net.biomeplus.client.model.animations.crabAnimation;
import net.biomeplus.entity.CrabEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CrabRenderer
extends MobRenderer<CrabEntity, Modelcrab<CrabEntity>> {
    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelcrab.LAYER_LOCATION)), 0.125f);
    }

    protected void scale(CrabEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.28f, 0.28f, 0.28f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(CrabEntity entity) {
        return ResourceLocation.parse((String)"biome_plus:textures/entities/crab.png");
    }

    private static final class AnimatedModel
    extends Modelcrab<CrabEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<CrabEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, crabAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, crabAnimation.crac, ageInTicks, 0.3f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

