/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.biomeplus.init.BiomePlusModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class BiomePlusModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            Holder dimensionType = levelStem.type();
            if (!dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) continue;
            ChunkGenerator chunkGenerator = levelStem.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.15f, (float)0.35f), Climate.Parameter.span((float)0.1f, (float)0.4f), Climate.Parameter.span((float)0.5f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)0.4f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"birch_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.15f, (float)0.35f), Climate.Parameter.span((float)0.1f, (float)0.4f), Climate.Parameter.span((float)0.5f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)0.4f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"birch_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.2f), Climate.Parameter.span((float)-0.4f, (float)0.45f), Climate.Parameter.span((float)0.3f, (float)0.6f), Climate.Parameter.span((float)-0.7f, (float)0.3f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"old_growth_birch_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.2f), Climate.Parameter.span((float)-0.4f, (float)0.45f), Climate.Parameter.span((float)0.3f, (float)0.6f), Climate.Parameter.span((float)-0.7f, (float)0.3f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"old_growth_birch_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.4f, (float)0.4f), Climate.Parameter.span((float)-0.3f, (float)0.3f), Climate.Parameter.span((float)0.2f, (float)0.6f), Climate.Parameter.span((float)-0.4f, (float)0.4f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.8f, (float)0.8f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"oak_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.4f, (float)0.4f), Climate.Parameter.span((float)-0.3f, (float)0.3f), Climate.Parameter.span((float)0.2f, (float)0.6f), Climate.Parameter.span((float)-0.4f, (float)0.4f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.8f, (float)0.8f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"oak_forest_plus")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)-0.15f, (float)0.15f), Climate.Parameter.span((float)0.2f, (float)1.0f), Climate.Parameter.span((float)0.1f, (float)0.4f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"original_biome")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)-0.15f, (float)0.15f), Climate.Parameter.span((float)0.2f, (float)1.0f), Climate.Parameter.span((float)0.1f, (float)0.4f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"original_biome")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)0.2f), Climate.Parameter.span((float)-0.3f, (float)0.3f), Climate.Parameter.span((float)0.2f, (float)0.5f), Climate.Parameter.span((float)-0.78f, (float)-0.37f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"violet_cherry_grove")))));
                BiomePlusModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)0.2f), Climate.Parameter.span((float)-0.3f, (float)0.3f), Climate.Parameter.span((float)0.2f, (float)0.5f), Climate.Parameter.span((float)-0.78f, (float)-0.37f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"violet_cherry_grove")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            ((BiomePlusModNoiseGeneratorSettings)noiseGenerator.settings.value()).setbiome_plusDimensionTypeReference((Holder<DimensionType>)dimensionType);
        }
    }

    public static SurfaceRules.RuleSource adaptSurfaceRule(SurfaceRules.RuleSource currentRuleSource, Holder<DimensionType> dimensionType) {
        if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
            return BiomePlusModBiomes.injectOverworldSurfaceRules(currentRuleSource);
        }
        return currentRuleSource;
    }

    private static SurfaceRules.RuleSource injectOverworldSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(BiomePlusModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"birch_forest_plus")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.SAND.defaultBlockState()));
        customSurfaceRules.add(BiomePlusModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"old_growth_birch_forest_plus")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.SAND.defaultBlockState()));
        customSurfaceRules.add(BiomePlusModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"oak_forest_plus")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.SAND.defaultBlockState()));
        customSurfaceRules.add(BiomePlusModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"original_biome")), ((Block)BiomePlusModBlocks.ORIGINAL_GRASS_BLOCK.get()).defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.SAND.defaultBlockState()));
        customSurfaceRules.add(BiomePlusModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biome_plus", (String)"violet_cherry_grove")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.SAND.defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    public static interface BiomePlusModNoiseGeneratorSettings {
        public void setbiome_plusDimensionTypeReference(Holder<DimensionType> var1);
    }
}

