/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.init;

import net.biomeplus.entity.AlexEntity;
import net.biomeplus.entity.BalloonEntity;
import net.biomeplus.entity.CrabEntity;
import net.biomeplus.entity.FawnEntity;
import net.biomeplus.entity.PigmanEntity;
import net.biomeplus.entity.PigmanZombieEntity;
import net.biomeplus.entity.UmanEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BiomePlusModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"biome_plus");
    public static final DeferredHolder<EntityType<?>, EntityType<FawnEntity>> FAWN = BiomePlusModEntities.register("fawn", EntityType.Builder.of(FawnEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BalloonEntity>> BALLOON = BiomePlusModEntities.register("balloon", EntityType.Builder.of(BalloonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<UmanEntity>> STEVE = BiomePlusModEntities.register("steve", EntityType.Builder.of(UmanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AlexEntity>> ALEX = BiomePlusModEntities.register("alex", EntityType.Builder.of(AlexEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<PigmanEntity>> PIGMAN = BiomePlusModEntities.register("pigman", EntityType.Builder.of(PigmanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<PigmanZombieEntity>> PIGMAN_ZOMBIE = BiomePlusModEntities.register("pigman_zombie", EntityType.Builder.of(PigmanZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CrabEntity>> CRAB = BiomePlusModEntities.register("crab", EntityType.Builder.of(CrabEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setUpdateInterval(3).sized(0.2f, 0.3f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)STEVE.get(), (living, context) -> living.getCombinedInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)PIGMAN.get(), (living, context) -> living.getCombinedInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        FawnEntity.init(event);
        BalloonEntity.init(event);
        UmanEntity.init(event);
        AlexEntity.init(event);
        PigmanEntity.init(event);
        PigmanZombieEntity.init(event);
        CrabEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)FAWN.get(), FawnEntity.createAttributes().build());
        event.put((EntityType)BALLOON.get(), BalloonEntity.createAttributes().build());
        event.put((EntityType)STEVE.get(), UmanEntity.createAttributes().build());
        event.put((EntityType)ALEX.get(), AlexEntity.createAttributes().build());
        event.put((EntityType)PIGMAN.get(), PigmanEntity.createAttributes().build());
        event.put((EntityType)PIGMAN_ZOMBIE.get(), PigmanZombieEntity.createAttributes().build());
        event.put((EntityType)CRAB.get(), CrabEntity.createAttributes().build());
    }
}

