/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BlockIdCommand {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientLoad(FMLClientSetupEvent event) {
    }

    @EventBusSubscriber
    private static class BlockIdForgeBusEvents {
        private BlockIdForgeBusEvents() {
        }

        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"blockid").then(Commands.argument((String)"block_name", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> {
                for (ResourceLocation rl : BuiltInRegistries.BLOCK.keySet()) {
                    builder.suggest(rl.toString());
                }
                return builder.buildFuture();
            }).executes(context -> BlockIdForgeBusEvents.executeBlockId((CommandContext<CommandSourceStack>)context))));
        }

        private static int executeBlockId(CommandContext<CommandSourceStack> context) {
            ResourceLocation rl = ResourceLocationArgument.getId(context, (String)"block_name");
            Block block = BuiltInRegistries.BLOCK.getOptional(rl).orElse(null);
            if (block == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cBlock not found: " + String.valueOf(rl))));
                return 0;
            }
            int id = BuiltInRegistries.BLOCK.getId((Object)block);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Block ID for " + String.valueOf(rl) + " is " + id)), false);
            return 1;
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
        }
    }
}

