/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class GiveBlockCommand {

    @EventBusSubscriber
    private static class CommandHandler {
        private CommandHandler() {
        }

        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            RequiredArgumentBuilder withTarget = (RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(BuiltInRegistries.BLOCK.size() - 1))).executes(context -> CommandHandler.executeGive((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), 1))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> CommandHandler.executeGive((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))));
            RequiredArgumentBuilder withoutTarget = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(BuiltInRegistries.BLOCK.size() - 1))).executes(context -> CommandHandler.executeGive((CommandContext<CommandSourceStack>)context, Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), 1))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> CommandHandler.executeGive((CommandContext<CommandSourceStack>)context, Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"giveblockid").then((ArgumentBuilder)withTarget)).then((ArgumentBuilder)withoutTarget));
        }

        private static int executeGive(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> targets, int blockId, int count) {
            Block block = (Block)BuiltInRegistries.BLOCK.byId(blockId);
            if (block == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cBlock not found for ID: " + blockId)));
                return 0;
            }
            ItemStack itemStack = new ItemStack((ItemLike)block.asItem(), count);
            if (itemStack.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis block cannot be given as an item"));
                return 0;
            }
            int successCount = 0;
            for (ServerPlayer player : targets) {
                if (!player.getInventory().add(itemStack.copy())) continue;
                ++successCount;
                player.containerMenu.broadcastChanges();
                if (targets.size() != 1) continue;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7aGiven \u00a7e" + count + "x \u00a7b" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + " \u00a7ato \u00a7e" + player.getDisplayName().getString())), true);
            }
            if (successCount == 0) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cCould not give items to any player"));
            } else if (targets.size() > 1) {
                int finalSuccessCount = successCount;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7aGiven \u00a7e" + count + "x \u00a7b" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + " \u00a7ato \u00a7e" + finalSuccessCount + " \u00a7aplayers")), true);
            }
            return successCount;
        }
    }
}

