/*
 * Decompiled with CFR 0.152.
 */
package net.biomeplus.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.biomeplus.client.model.Modelcrab;
import net.biomeplus.client.model.animations.crabAnimation;
import net.biomeplus.entity.CrabEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrabRenderer
extends MobRenderer<CrabEntity, LivingEntityRenderState, Modelcrab> {
    private CrabEntity entity = null;

    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelcrab.LAYER_LOCATION)), 0.125f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CrabEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"biome_plus:textures/entities/crab.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(0.28f, 0.28f, 0.28f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelcrab {
        private CrabEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(CrabEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, crabAnimation.idle, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState1, crabAnimation.crac, state.ageInTicks, 0.3f);
            super.setupAnim(state);
        }
    }
}

