/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.adapter;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import java.util.Optional;
import lombok.Generated;
import net.bitbylogic.packetblocks.data.PacketBlock;
import net.bitbylogic.packetblocks.manager.PacketBlockManager;
import net.bitbylogic.packetblocks.util.PacketBlockUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockSupport;
import org.bukkit.entity.Player;

public class BlockPlaceAdapter
implements PacketListener {
    private final PacketBlockManager manager;

    public void onPacketReceive(PacketReceiveEvent event) {
        Material blockType;
        if (event.getPacketType() != PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Material mainHandType = player.getInventory().getItemInMainHand().getType();
        Material offHandType = player.getInventory().getItemInOffHand().getType();
        Material material = mainHandType.isBlock() ? mainHandType : (blockType = offHandType.isBlock() ? offHandType : Material.AIR);
        if (blockType == Material.AIR) {
            return;
        }
        WrapperPlayClientPlayerBlockPlacement wrapper = new WrapperPlayClientPlayerBlockPlacement(event);
        com.github.retrooper.packetevents.protocol.world.BlockFace direction = wrapper.getFace();
        Vector3i position = wrapper.getBlockPosition();
        Location originalLoc = new Location(player.getWorld(), (double)position.getX(), (double)position.getY(), (double)position.getZ());
        if (originalLoc.getBlock().getType().isInteractable()) {
            return;
        }
        Location location = originalLoc.clone();
        BlockFace bukkitFace = BlockFace.valueOf((String)direction.name());
        Material currentBlockType = PacketBlockUtil.getBlockType(player, location);
        boolean shifted = false;
        if (!currentBlockType.isAir() && location.getBlock().getBlockData().isFaceSturdy(bukkitFace, BlockSupport.FULL)) {
            location.add(bukkitFace.getDirection());
            shifted = true;
        }
        if (blockType.createBlockData().getCollisionShape(location).overlaps(player.getBoundingBox()) && blockType.isCollidable()) {
            return;
        }
        Optional<PacketBlock> optionalBlock = this.manager.getBlock(location);
        if (optionalBlock.isEmpty()) {
            return;
        }
        PacketBlock packetBlock = optionalBlock.get();
        if (!packetBlock.isViewer(player)) {
            return;
        }
        location.add(bukkitFace.getDirection());
        Material newCurrentBlockType = PacketBlockUtil.getBlockType(player, location);
        if (shifted || !newCurrentBlockType.isAir()) {
            event.setCancelled(true);
            return;
        }
        wrapper.setBlockPosition(new Vector3i(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
    }

    @Generated
    public BlockPlaceAdapter(PacketBlockManager manager) {
        this.manager = manager;
    }
}

