/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.data.PacketBlockPlayerData;
import net.bitbylogic.packetblocks.event.PacketBlockBreakEvent;
import net.bitbylogic.packetblocks.lib.bitsutils.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

public class PacketBlock {
    private final World world;
    private final Location location;
    private final Pair<Integer, Integer> chunk;
    private final BoundingBox boundingBox;
    private final Set<Predicate<Player>> viewConditions;
    private final HashMap<UUID, PacketBlockPlayerData> viewers;
    private final HashMap<String, Object> metadata;
    private BlockData blockData;
    private int breakSpeed = -1;
    private boolean addViewerOnJoin;
    private boolean globalBreakAnimation;

    public PacketBlock(@NonNull Location location, @NonNull BlockData blockData) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (blockData == null) {
            throw new NullPointerException("blockData is marked non-null but is null");
        }
        this.world = location.getWorld();
        this.location = location;
        this.chunk = new Pair<Integer, Integer>(location.getChunk().getX(), location.getChunk().getZ());
        this.boundingBox = BoundingBox.of((Location)location.clone(), (Location)location.clone().add(1.0, 1.0, 1.0));
        this.blockData = blockData;
        this.viewConditions = new HashSet<Predicate<Player>>();
        this.viewers = new HashMap();
        this.metadata = new HashMap();
    }

    public boolean canView(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.viewConditions.stream().allMatch(viewRequirement -> viewRequirement.test(player));
    }

    public boolean isViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.viewers.containsKey(player.getUniqueId());
    }

    public Optional<PacketBlockPlayerData> getViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return Optional.ofNullable(this.viewers.get(player.getUniqueId()));
    }

    public Optional<PacketBlockPlayerData> attemptAddViewer(@NonNull Player player, boolean sendUpdate) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (!this.canView(player)) {
            return Optional.empty();
        }
        if (this.isViewer(player)) {
            return this.getViewer(player);
        }
        PacketBlockPlayerData playerData = new PacketBlockPlayerData(null, () -> this.blockData, this.breakSpeed);
        this.viewers.put(player.getUniqueId(), playerData);
        if (sendUpdate) {
            this.sendUpdate(player);
        }
        return Optional.of(playerData);
    }

    public PacketBlockPlayerData addViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketBlockPlayerData playerData = new PacketBlockPlayerData(null, () -> this.blockData, this.breakSpeed);
        this.viewers.put(player.getUniqueId(), playerData);
        return playerData;
    }

    public PacketBlockPlayerData addAndUpdateViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketBlockPlayerData playerData = this.addViewer(player);
        this.sendUpdate(player);
        return playerData;
    }

    public PacketBlockPlayerData addViewer(@NonNull Player player, @NonNull Supplier<BlockData> blockDataSupplier) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (blockDataSupplier == null) {
            throw new NullPointerException("blockDataSupplier is marked non-null but is null");
        }
        PacketBlockPlayerData playerData = new PacketBlockPlayerData(null, blockDataSupplier, this.breakSpeed);
        this.viewers.put(player.getUniqueId(), playerData);
        return playerData;
    }

    public PacketBlockPlayerData addAndUpdateViewer(@NonNull Player player, @NonNull Supplier<BlockData> blockDataSupplier) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (blockDataSupplier == null) {
            throw new NullPointerException("blockDataSupplier is marked non-null but is null");
        }
        PacketBlockPlayerData playerData = this.addViewer(player, blockDataSupplier);
        this.sendUpdate(player);
        return playerData;
    }

    public void removeViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (!this.viewers.containsKey(player.getUniqueId())) {
            return;
        }
        this.viewers.remove(player.getUniqueId());
        player.sendBlockChange(this.location, this.location.getBlock().getBlockData());
    }

    public void setBlockDataForAll(@NonNull BlockData blockData) {
        if (blockData == null) {
            throw new NullPointerException("blockData is marked non-null but is null");
        }
        this.blockData = blockData;
        this.viewers.values().forEach(playerData -> playerData.setBlockData(blockData));
        this.sendUpdates();
    }

    public void setBlockDataSupplierForAll(@NonNull BlockData blockData) {
        if (blockData == null) {
            throw new NullPointerException("blockData is marked non-null but is null");
        }
        this.blockData = blockData;
        this.viewers.values().forEach(playerData -> playerData.setBlockDataSupplier(() -> blockData));
        this.sendUpdates();
    }

    public void setBlockData(@NonNull Player player, @Nullable BlockData blockData) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Optional<PacketBlockPlayerData> optionalPlayerData = this.getViewer(player);
        if (optionalPlayerData.isEmpty()) {
            return;
        }
        optionalPlayerData.get().setBlockData(blockData);
    }

    public void setBlockDataSupplier(@NonNull Player player, @NonNull BlockData blockData) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (blockData == null) {
            throw new NullPointerException("blockData is marked non-null but is null");
        }
        Optional<PacketBlockPlayerData> optionalPlayerData = this.getViewer(player);
        if (optionalPlayerData.isEmpty()) {
            return;
        }
        optionalPlayerData.get().setBlockDataSupplier(() -> blockData);
    }

    public void setBlockDataAndUpdate(@NonNull Player player, @Nullable BlockData blockData) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.setBlockData(player, blockData);
        this.sendUpdate(player);
    }

    public BlockState getBlockState(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.getViewer(player).map(playerData -> playerData.getBlockData() == null ? playerData.getBlockDataSupplier().get() : playerData.getBlockData()).orElse(this.blockData).createBlockState().copy(this.location);
    }

    public void addMetadata(@NonNull String key, @NonNull Object object) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (this.metadata.containsKey(key)) {
            return;
        }
        this.metadata.put(key, object);
    }

    public void removeMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.metadata.remove(key);
    }

    public boolean hasMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadata.containsKey(key);
    }

    public Object getMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getMetadata(key, null);
    }

    public <T> T getMetadataAs(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)this.getMetadata(key, null);
    }

    public Object getMetadata(@NonNull String key, @Nullable Object fallback) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadata.getOrDefault(key, fallback);
    }

    public void addMetadata(@NonNull Player player, @NonNull String key, @NonNull Object object) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.getViewer(player).ifPresent(playerData -> playerData.addMetadata(key, object));
    }

    public void removeMetadata(@NonNull Player player, @NonNull String key) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.getViewer(player).ifPresent(playerData -> playerData.removeMetadata(key));
    }

    public boolean hasMetadata(@NonNull Player player, @NonNull String key) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getViewer(player).map(playerData -> playerData.hasMetadata(key)).orElse(false);
    }

    public Object getMetadata(@NonNull Player player, @NonNull String key) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getMetadataAs(player, key, null);
    }

    public Object getMetadataAs(@NonNull Player player, @NonNull String key, @Nullable Object fallback) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getViewer(player).map(playerData -> playerData.getMetadata(key)).orElse(fallback);
    }

    public void sendUpdate(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        player.sendBlockChange(this.location, this.getBlockState(player).getBlockData());
    }

    public void sendUpdates() {
        Iterator<UUID> viewerIterator = this.viewers.keySet().iterator();
        while (viewerIterator.hasNext()) {
            Player viewer = Bukkit.getPlayer((UUID)viewerIterator.next());
            if (viewer == null) {
                viewerIterator.remove();
                continue;
            }
            viewer.sendBlockChange(this.location, this.getBlockState(viewer).getBlockData());
        }
    }

    public int getBreakSpeed(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.getViewer(player).map(PacketBlockPlayerData::getBreakSpeed).orElse(this.breakSpeed);
    }

    public void simulateBreak(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.simulateBreak(player, null);
    }

    public void simulateBreak(@NonNull Player player, @Nullable ItemStack tool) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Bukkit.getScheduler().runTask((Plugin)PacketBlocks.getInstance(), () -> {
            PacketBlockBreakEvent breakEvent = new PacketBlockBreakEvent(player, this, this.location, tool);
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (breakEvent.isCancelled()) {
                this.sendUpdate(player);
                return;
            }
            if (!breakEvent.isDropItems()) {
                return;
            }
            this.getBlockState(player).getBlock().getDrops(player.getInventory().getItemInMainHand(), (Entity)player).forEach(drop -> player.getWorld().dropItemNaturally(this.location, drop));
        });
    }

    public void addViewCondition(@NonNull Predicate<Player> condition) {
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        if (this.viewConditions.contains(condition)) {
            return;
        }
        this.viewConditions.add(condition);
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public Pair<Integer, Integer> getChunk() {
        return this.chunk;
    }

    @Generated
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Generated
    public Set<Predicate<Player>> getViewConditions() {
        return this.viewConditions;
    }

    @Generated
    public HashMap<UUID, PacketBlockPlayerData> getViewers() {
        return this.viewers;
    }

    @Generated
    public HashMap<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public BlockData getBlockData() {
        return this.blockData;
    }

    @Generated
    public int getBreakSpeed() {
        return this.breakSpeed;
    }

    @Generated
    public boolean isAddViewerOnJoin() {
        return this.addViewerOnJoin;
    }

    @Generated
    public boolean isGlobalBreakAnimation() {
        return this.globalBreakAnimation;
    }

    @Generated
    public void setBreakSpeed(int breakSpeed) {
        this.breakSpeed = breakSpeed;
    }

    @Generated
    public void setAddViewerOnJoin(boolean addViewerOnJoin) {
        this.addViewerOnJoin = addViewerOnJoin;
    }

    @Generated
    public void setGlobalBreakAnimation(boolean globalBreakAnimation) {
        this.globalBreakAnimation = globalBreakAnimation;
    }
}

