/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtil {
    public static String join(int index, String[] array, String delimiter) {
        if (index >= array.length) {
            throw new IndexOutOfBoundsException("Specified index is greater than array length");
        }
        CharSequence[] newArray = new String[array.length - index];
        for (int i = index; i < array.length; ++i) {
            newArray[i - index] = array[i];
        }
        return String.join((CharSequence)delimiter, newArray);
    }

    public static String capitalize(String string) {
        return Stream.of(string.toLowerCase().trim().split("\\s")).filter(word -> word.length() > 0).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    public static long calculateReadingTime(String string, int readingSpeed) {
        double numberOfWords = string.split(" ").length;
        double readingTime = numberOfWords / (double)readingSpeed;
        return (long)(readingTime * 1000.0);
    }
}

