/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.action.data.StringActionData;
import net.bitbylogic.packetblocks.lib.bitsutils.action.parsed.ParsedAction;
import net.bitbylogic.packetblocks.lib.bitsutils.action.reference.ActionReference;

public class ActionParser {
    public static List<ParsedAction> parseActions(@NonNull List<String> dataList) {
        if (dataList == null) {
            throw new NullPointerException("dataList is marked non-null but is null");
        }
        ArrayList<ParsedAction> actions = new ArrayList<ParsedAction>();
        dataList.forEach(actionData -> ActionParser.parseAction(actionData).ifPresent(actions::add));
        return actions;
    }

    public static Optional<ParsedAction> parseAction(@NonNull String actionData) {
        if (actionData == null) {
            throw new NullPointerException("actionData is marked non-null but is null");
        }
        String[] data = actionData.split(":", 2);
        String id = data[0];
        return Optional.of(new ParsedAction(new ActionReference(id), new StringActionData(actionData)));
    }
}

