/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.cooldown;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.TimeConverter;
import net.bitbylogic.packetblocks.lib.bitsutils.cooldown.Cooldown;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CooldownUtil {
    private static final HashMap<UUID, List<Cooldown>> COOLDOWNS = new HashMap();

    public static void startCooldown(String key, UUID identifier) {
        List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
        currentCooldowns.add(new Cooldown(identifier, key, -1L));
        COOLDOWNS.put(identifier, currentCooldowns);
    }

    public static void startCooldown(JavaPlugin plugin, String key, UUID identifier, long expireTime, TimeUnit unit) {
        List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
        Cooldown cooldown = new Cooldown(identifier, key, unit.toMillis(expireTime));
        currentCooldowns.add(cooldown);
        COOLDOWNS.put(identifier, currentCooldowns);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            List updatedCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
            updatedCooldowns.remove(cooldown);
            COOLDOWNS.put(identifier, updatedCooldowns);
        }, unit.toMillis(expireTime) / 50L);
    }

    public static void startCooldown(JavaPlugin plugin, String key, UUID identifier, long expireTime, TimeUnit unit, Consumer<Void> completeCallback) {
        List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
        Cooldown cooldown = new Cooldown(identifier, key, unit.toMillis(expireTime));
        currentCooldowns.add(cooldown);
        COOLDOWNS.put(identifier, currentCooldowns);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            List updatedCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
            updatedCooldowns.remove(cooldown);
            COOLDOWNS.put(identifier, updatedCooldowns);
            completeCallback.accept(null);
        }, unit.toMillis(expireTime) / 50L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attemptRun(String key, UUID identifier, String cooldownTime, Runnable runnable) {
        HashMap<UUID, List<Cooldown>> hashMap = COOLDOWNS;
        synchronized (hashMap) {
            if (!CooldownUtil.hasCooldown(key, identifier)) {
                List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
                Cooldown cooldown2 = new Cooldown(identifier, key, TimeConverter.convert(cooldownTime));
                currentCooldowns.add(cooldown2);
                COOLDOWNS.put(identifier, currentCooldowns);
                runnable.run();
                return;
            }
            CooldownUtil.getCooldown(key, identifier).ifPresent(cooldown -> {
                if (cooldown.isActive()) {
                    return;
                }
                List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
                Cooldown newCooldown = new Cooldown(identifier, key, TimeConverter.convert(cooldownTime));
                currentCooldowns.remove(cooldown);
                currentCooldowns.add(newCooldown);
                COOLDOWNS.put(identifier, currentCooldowns);
                runnable.run();
            });
        }
    }

    public static void endCooldown(String key, UUID identifier) {
        List currentCooldowns = COOLDOWNS.getOrDefault(identifier, new ArrayList());
        currentCooldowns.removeIf(cooldown -> cooldown.getIdentifier().equals(identifier) && cooldown.getCooldownId().equalsIgnoreCase(key));
    }

    public static Optional<Cooldown> getCooldown(@NonNull String key, @NonNull UUID identifier) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        return ((List)COOLDOWNS.getOrDefault(identifier, new ArrayList())).stream().filter(cd -> cd != null && cd.getCooldownId().equalsIgnoreCase(key)).findFirst();
    }

    public static boolean hasCooldown(String key, UUID identifier) {
        return CooldownUtil.getCooldown(key, identifier).isPresent();
    }

    public static double getRemainingTime(@NonNull String key, @NonNull UUID identifier) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (!CooldownUtil.hasCooldown(key, identifier)) {
            return -1.0;
        }
        return CooldownUtil.getCooldown(key, identifier).map(cooldown -> (double)cooldown.getTimeUntilExpired() / 1000.0).orElse(-1.0);
    }

    public static String getReadableRemainingTime(@NonNull String key, @NonNull UUID identifier) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        double remainingTime = CooldownUtil.getRemainingTime(key, identifier);
        return String.format(remainingTime < 1.0 ? "%.1f" : "%.0f", remainingTime);
    }
}

