/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.hologram;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.Hologram;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.line.HologramBlockLine;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.line.HologramItemLine;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.line.HologramTextLine;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.type.HologramType;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.Formatter;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class HologramLine<SELF extends HologramLine<SELF, T>, T> {
    private final Transformation transformation = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
    @NonNull
    private String id = UUID.randomUUID().toString();
    private Display.Billboard billboard;
    private Display.Brightness brightness;
    private boolean glowing;
    private Color glowColor;
    private float yaw;
    private float pitch;
    private long updateInterval = 50L;
    private T data;
    private Supplier<T> dataSupplier;
    @Nullable
    private transient Display display;
    @Nullable
    protected transient Hologram hologram;
    protected transient long lastUpdateTime;

    public HologramLine(@NonNull T data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }

    public HologramLine(@NonNull Supplier<T> dataSupplier) {
        if (dataSupplier == null) {
            throw new NullPointerException("dataSupplier is marked non-null but is null");
        }
        this.dataSupplier = dataSupplier;
    }

    public Optional<T> getData() {
        return this.dataSupplier == null ? Optional.ofNullable(this.data) : Optional.ofNullable(this.dataSupplier.get());
    }

    protected abstract SELF self();

    public abstract HologramType getType();

    protected void updateData() {
        if (this.display == null || this.getData().isEmpty()) {
            return;
        }
        T data = this.getData().get();
        switch (this.getType()) {
            case TEXT: {
                TextDisplay textDisplay = (TextDisplay)this.display;
                textDisplay.setText(Formatter.format((String)data, new StringModifier[0]));
                break;
            }
            case ITEM: {
                ItemDisplay itemDisplay = (ItemDisplay)this.display;
                itemDisplay.setItemStack((ItemStack)data);
                break;
            }
            case BLOCK: {
                BlockDisplay blockDisplay = (BlockDisplay)this.display;
                blockDisplay.setBlock((BlockData)data);
            }
        }
    }

    public SELF id(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        return this.self();
    }

    public SELF billboard(@NonNull Display.Billboard billboard) {
        if (billboard == null) {
            throw new NullPointerException("billboard is marked non-null but is null");
        }
        this.billboard = billboard;
        return this.self();
    }

    public SELF brightness(@NonNull Display.Brightness brightness) {
        if (brightness == null) {
            throw new NullPointerException("brightness is marked non-null but is null");
        }
        this.brightness = brightness;
        return this.self();
    }

    public SELF glowing(boolean glowing) {
        this.glowing = glowing;
        return this.self();
    }

    public SELF glowColor(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.glowColor = color;
        return this.self();
    }

    public SELF yaw(float yaw) {
        this.yaw = yaw;
        return this.self();
    }

    public SELF pitch(float pitch) {
        this.pitch = pitch;
        return this.self();
    }

    public SELF updateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
        return this.self();
    }

    public SELF data(@NonNull T data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        if (this.display != null) {
            this.updateData();
        }
        return this.self();
    }

    public SELF data(@NonNull Supplier<T> dataSupplier) {
        if (dataSupplier == null) {
            throw new NullPointerException("dataSupplier is marked non-null but is null");
        }
        this.dataSupplier = dataSupplier;
        if (this.display != null) {
            this.updateData();
        }
        return this.self();
    }

    public SELF scale(float scale) {
        this.transformation.getScale().set(scale);
        return this.self();
    }

    public SELF translation(@NonNull Vector3f translation) {
        if (translation == null) {
            throw new NullPointerException("translation is marked non-null but is null");
        }
        this.transformation.getTranslation().set((Vector3fc)translation);
        return this.self();
    }

    public SELF rotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        return this.self();
    }

    protected Display build(@NonNull Location location, boolean persistent, boolean global) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (location.getWorld() == null) {
            throw new IllegalArgumentException("Invalid location, world cannot be null");
        }
        switch (this.getType()) {
            case TEXT: {
                TextDisplay textDisplay = (TextDisplay)location.getWorld().spawn(location, TextDisplay.class);
                HologramTextLine textLine = (HologramTextLine)this;
                textDisplay.setText(Formatter.format(textLine.getData().orElse(""), new StringModifier[0]));
                textDisplay.setBackgroundColor(textLine.getBackgroundColor() == null ? textDisplay.getBackgroundColor() : textLine.getBackgroundColor());
                textDisplay.setTextOpacity(textLine.getOpacity() == -1 ? textDisplay.getTextOpacity() : textLine.getOpacity());
                textDisplay.setShadowed(textLine.isShadow());
                textDisplay.setSeeThrough(textLine.isSeeThrough());
                textDisplay.setAlignment(textLine.getAlignment() == null ? textDisplay.getAlignment() : textLine.getAlignment());
                this.display = textDisplay;
                break;
            }
            case ITEM: {
                ItemDisplay itemDisplay = (ItemDisplay)location.getWorld().spawn(location, ItemDisplay.class);
                HologramItemLine itemLine = (HologramItemLine)this;
                itemDisplay.setItemStack(itemLine.getData().orElse(new ItemStack(Material.BARRIER)));
                itemDisplay.setItemDisplayTransform(itemLine.getDisplayTransform() == null ? itemDisplay.getItemDisplayTransform() : itemLine.getDisplayTransform());
                this.display = itemDisplay;
                break;
            }
            case BLOCK: {
                BlockDisplay blockDisplay = (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class);
                HologramBlockLine blockLine = (HologramBlockLine)this;
                blockDisplay.setBlock(blockLine.getData().orElse(Material.OAK_LOG.createBlockData()));
                this.display = blockDisplay;
            }
        }
        this.display.setVisibleByDefault(global);
        this.display.setPersistent(persistent);
        this.display.setTeleportDuration(1);
        this.display.setBillboard(this.billboard == null ? this.display.getBillboard() : this.billboard);
        this.display.setBrightness(this.brightness == null ? this.display.getBrightness() : this.brightness);
        this.display.setGlowing(this.glowing);
        this.display.setGlowColorOverride(this.glowColor == null ? this.display.getGlowColorOverride() : this.glowColor);
        this.display.setTransformation(this.transformation);
        this.display.setRotation(this.yaw, this.pitch);
        return this.display;
    }

    public static HologramTextLine of(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return new HologramTextLine(text);
    }

    @Generated
    public Transformation getTransformation() {
        return this.transformation;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    @Generated
    public Display.Brightness getBrightness() {
        return this.brightness;
    }

    @Generated
    public boolean isGlowing() {
        return this.glowing;
    }

    @Generated
    public Color getGlowColor() {
        return this.glowColor;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public long getUpdateInterval() {
        return this.updateInterval;
    }

    @Generated
    public Supplier<T> getDataSupplier() {
        return this.dataSupplier;
    }

    @Nullable
    @Generated
    public Display getDisplay() {
        return this.display;
    }

    @Nullable
    @Generated
    public Hologram getHologram() {
        return this.hologram;
    }

    @Generated
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public void setHologram(@Nullable Hologram hologram) {
        this.hologram = hologram;
    }

    @Generated
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }
}

